/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.validator.attestation.trustworthiness.self;

import com.webauthn4j.attestation.statement.CertificateBaseAttestationStatement;
import com.webauthn4j.validator.attestation.trustworthiness.self.SelfAttestationTrustworthinessValidator;
import com.webauthn4j.validator.exception.CertificateException;
import com.webauthn4j.validator.exception.SelfAttestationProhibitedException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;

public class DefaultSelfAttestationTrustworthinessValidator
implements SelfAttestationTrustworthinessValidator {
    private boolean isSelfAttestationAllowed = true;

    @Override
    public void validate(CertificateBaseAttestationStatement attestationStatement) {
        if (this.isSelfAttestationAllowed()) {
            X509Certificate attestationCertificate = attestationStatement.getX5c().getEndEntityAttestationCertificate().getCertificate();
            try {
                attestationCertificate.checkValidity();
            }
            catch (CertificateExpiredException e) {
                throw new CertificateException("Certificate expired", e);
            }
            catch (CertificateNotYetValidException e) {
                throw new CertificateException("Certificate not yet valid", e);
            }
        } else {
            throw new SelfAttestationProhibitedException("SELF attestations is prohibited by configuration");
        }
    }

    public boolean isSelfAttestationAllowed() {
        return this.isSelfAttestationAllowed;
    }

    public void setSelfAttestationAllowed(boolean selfAttestationAllowed) {
        this.isSelfAttestationAllowed = selfAttestationAllowed;
    }
}

