/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.attestation.statement;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum COSEKeyType {
    OKP(1),
    EC2(2),
    RSA(3),
    SYMMETRIC(4),
    RESERVED(0);

    private final int value;

    private COSEKeyType(int value) {
        this.value = value;
    }

    @JsonCreator
    public static COSEKeyType create(int value) {
        switch (value) {
            case 1: {
                return OKP;
            }
            case 2: {
                return EC2;
            }
            case 3: {
                return RSA;
            }
            case 4: {
                return SYMMETRIC;
            }
            case 0: {
                return RESERVED;
            }
        }
        throw new IllegalArgumentException("value is out of range");
    }

    @JsonValue
    public int getValue() {
        return this.value;
    }
}

