/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.converter.jackson.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.webauthn4j.extension.client.AuthenticatorSelectionClientExtensionOutput;
import com.webauthn4j.extension.client.BiometricAuthenticatorPerformanceBoundsClientExtensionOutput;
import com.webauthn4j.extension.client.ClientExtensionOutput;
import com.webauthn4j.extension.client.FIDOAppIDClientExtensionOutput;
import com.webauthn4j.extension.client.GenericTransactionAuthorizationClientExtensionOutput;
import com.webauthn4j.extension.client.LocationClientExtensionOutput;
import com.webauthn4j.extension.client.SimpleTransactionAuthorizationClientExtensionOutput;
import com.webauthn4j.extension.client.SupportedExtensionsClientExtensionOutput;
import com.webauthn4j.extension.client.UserVerificationIndexClientExtensionOutput;
import com.webauthn4j.util.exception.NotImplementedException;
import java.io.IOException;

public class ClientExtensionOutputDeserializer
extends StdDeserializer<ClientExtensionOutput> {
    public ClientExtensionOutputDeserializer() {
        super(ClientExtensionOutput.class);
    }

    public ClientExtensionOutput deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        String currentName = p.getParsingContext().getCurrentName();
        if (FIDOAppIDClientExtensionOutput.ID.getValue().equals(currentName)) {
            return (ClientExtensionOutput)ctxt.readValue(p, FIDOAppIDClientExtensionOutput.class);
        }
        if (SimpleTransactionAuthorizationClientExtensionOutput.ID.getValue().equals(currentName)) {
            return (ClientExtensionOutput)ctxt.readValue(p, SimpleTransactionAuthorizationClientExtensionOutput.class);
        }
        if (UserVerificationIndexClientExtensionOutput.ID.getValue().equals(currentName)) {
            return (ClientExtensionOutput)ctxt.readValue(p, UserVerificationIndexClientExtensionOutput.class);
        }
        String parentName = p.getParsingContext().getParent().getCurrentName();
        if (GenericTransactionAuthorizationClientExtensionOutput.ID.getValue().equals(parentName)) {
            return (ClientExtensionOutput)ctxt.readValue(p, GenericTransactionAuthorizationClientExtensionOutput.class);
        }
        if (AuthenticatorSelectionClientExtensionOutput.ID.getValue().equals(parentName)) {
            return (ClientExtensionOutput)ctxt.readValue(p, AuthenticatorSelectionClientExtensionOutput.class);
        }
        if (SupportedExtensionsClientExtensionOutput.ID.getValue().equals(parentName)) {
            return (ClientExtensionOutput)ctxt.readValue(p, SupportedExtensionsClientExtensionOutput.class);
        }
        if (LocationClientExtensionOutput.ID.getValue().equals(parentName)) {
            return (ClientExtensionOutput)ctxt.readValue(p, LocationClientExtensionOutput.class);
        }
        if (UserVerificationIndexClientExtensionOutput.ID.getValue().equals(parentName)) {
            return (ClientExtensionOutput)ctxt.readValue(p, UserVerificationIndexClientExtensionOutput.class);
        }
        if (BiometricAuthenticatorPerformanceBoundsClientExtensionOutput.ID.getValue().equals(parentName)) {
            return (ClientExtensionOutput)ctxt.readValue(p, BiometricAuthenticatorPerformanceBoundsClientExtensionOutput.class);
        }
        throw new NotImplementedException();
    }
}

