/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.converter;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.webauthn4j.client.CollectedClientData;
import com.webauthn4j.converter.jackson.ObjectMapperUtil;
import com.webauthn4j.util.Base64UrlUtil;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;

public class CollectedClientDataConverter {
    private final ObjectMapper jsonMapper = ObjectMapperUtil.createJSONMapper();

    public CollectedClientData convert(String base64UrlString) {
        byte[] bytes = Base64UrlUtil.decode((String)base64UrlString);
        return this.convert(bytes);
    }

    public CollectedClientData convert(byte[] source) {
        String jsonString = new String(source, StandardCharsets.UTF_8);
        try {
            return (CollectedClientData)this.jsonMapper.readValue(jsonString, CollectedClientData.class);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public byte[] convertToBytes(CollectedClientData source) {
        try {
            return this.jsonMapper.writeValueAsBytes((Object)source);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public String convertToString(CollectedClientData source) {
        byte[] bytes = this.convertToBytes(source);
        return Base64UrlUtil.encodeToString((byte[])bytes);
    }
}

