/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j;

import com.webauthn4j.AbstractWebAuthnContext;
import com.webauthn4j.extension.ExtensionIdentifier;
import com.webauthn4j.server.ServerProperty;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class WebAuthnRegistrationContext
extends AbstractWebAuthnContext {
    private final byte[] attestationObject;

    public WebAuthnRegistrationContext(byte[] collectedClientData, byte[] attestationObject, byte[] clientExtensionOutputs, ServerProperty serverProperty, boolean userVerificationRequired, List<ExtensionIdentifier> expectedExtensions) {
        super(collectedClientData, clientExtensionOutputs, serverProperty, userVerificationRequired, expectedExtensions);
        this.attestationObject = attestationObject;
    }

    public WebAuthnRegistrationContext(byte[] collectedClientData, byte[] attestationObject, ServerProperty serverProperty, boolean userVerificationRequired) {
        this(collectedClientData, attestationObject, null, serverProperty, userVerificationRequired, Collections.emptyList());
    }

    public byte[] getAttestationObject() {
        return this.attestationObject;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        WebAuthnRegistrationContext that = (WebAuthnRegistrationContext)o;
        return Arrays.equals(this.attestationObject, that.attestationObject);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.attestationObject);
        return result;
    }
}

