/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j;

import com.webauthn4j.AbstractWebAuthnContext;
import com.webauthn4j.extension.ExtensionIdentifier;
import com.webauthn4j.server.ServerProperty;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class WebAuthnAuthenticationContext
extends AbstractWebAuthnContext {
    private final byte[] credentialId;
    private final byte[] authenticatorData;
    private final byte[] signature;

    public WebAuthnAuthenticationContext(byte[] credentialId, byte[] collectedClientData, byte[] authenticatorData, byte[] signature, byte[] clientExtensionOutputs, ServerProperty serverProperty, boolean userVerificationRequired, List<ExtensionIdentifier> expectedExtensions) {
        super(collectedClientData, clientExtensionOutputs, serverProperty, userVerificationRequired, expectedExtensions);
        this.credentialId = credentialId;
        this.signature = signature;
        this.authenticatorData = authenticatorData;
    }

    public WebAuthnAuthenticationContext(byte[] credentialId, byte[] collectedClientData, byte[] authenticatorData, byte[] signature, ServerProperty serverProperty, boolean userVerificationRequired) {
        this(credentialId, collectedClientData, authenticatorData, signature, null, serverProperty, userVerificationRequired, Collections.emptyList());
    }

    public byte[] getCredentialId() {
        return this.credentialId;
    }

    public byte[] getAuthenticatorData() {
        return this.authenticatorData;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        WebAuthnAuthenticationContext that = (WebAuthnAuthenticationContext)o;
        return Arrays.equals(this.authenticatorData, that.authenticatorData) && Arrays.equals(this.signature, that.signature);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.authenticatorData);
        result = 31 * result + Arrays.hashCode(this.signature);
        return result;
    }
}

