/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j;

import com.webauthn4j.extension.ExtensionIdentifier;
import com.webauthn4j.server.ServerProperty;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

class AbstractWebAuthnContext {
    private final byte[] collectedClientData;
    private final byte[] clientExtensionOutputs;
    private final ServerProperty serverProperty;
    private boolean userVerificationRequired;
    private List<ExtensionIdentifier> expectedExtensions;

    public AbstractWebAuthnContext(byte[] collectedClientData, byte[] clientExtensionOutputs, ServerProperty serverProperty, boolean userVerificationRequired, List<ExtensionIdentifier> expectedExtensions) {
        this.collectedClientData = collectedClientData;
        this.clientExtensionOutputs = clientExtensionOutputs;
        this.serverProperty = serverProperty;
        this.userVerificationRequired = userVerificationRequired;
        this.expectedExtensions = expectedExtensions;
    }

    public byte[] getCollectedClientData() {
        return this.collectedClientData;
    }

    public String getCollectedClientDataJson() {
        return new String(this.collectedClientData, StandardCharsets.UTF_8);
    }

    public byte[] getClientExtensionOutputs() {
        return this.clientExtensionOutputs;
    }

    public ServerProperty getServerProperty() {
        return this.serverProperty;
    }

    public boolean isUserVerificationRequired() {
        return this.userVerificationRequired;
    }

    public List<ExtensionIdentifier> getExpectedExtensions() {
        return this.expectedExtensions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractWebAuthnContext that = (AbstractWebAuthnContext)o;
        return this.userVerificationRequired == that.userVerificationRequired && Arrays.equals(this.collectedClientData, that.collectedClientData) && Arrays.equals(this.clientExtensionOutputs, that.clientExtensionOutputs) && Objects.equals(this.serverProperty, that.serverProperty) && Objects.equals(this.expectedExtensions, that.expectedExtensions);
    }

    public int hashCode() {
        int result = Objects.hash(this.serverProperty, this.userVerificationRequired, this.expectedExtensions);
        result = 31 * result + Arrays.hashCode(this.collectedClientData);
        result = 31 * result + Arrays.hashCode(this.clientExtensionOutputs);
        return result;
    }
}

