/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.attestation.authenticator;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.webauthn4j.attestation.authenticator.CredentialPublicKey;
import com.webauthn4j.attestation.statement.COSEAlgorithmIdentifier;
import com.webauthn4j.attestation.statement.COSEKeyType;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Arrays;
import java.util.Objects;

public abstract class AbstractCredentialPublicKey
implements CredentialPublicKey {
    @JsonProperty(value="1")
    private COSEKeyType keyType;
    @JsonProperty(value="2")
    private byte[] keyId;
    @JsonProperty(value="3")
    private COSEAlgorithmIdentifier algorithm;
    @JsonProperty(value="4")
    private int[] keyOpts;
    @JsonProperty(value="5")
    private byte[] baseIV;

    AbstractCredentialPublicKey(COSEKeyType keyType, byte[] keyId, COSEAlgorithmIdentifier algorithm, int[] keyOpts, byte[] baseIV) {
        this.keyType = keyType;
        this.keyId = keyId;
        this.algorithm = algorithm;
        this.keyOpts = keyOpts;
        this.baseIV = baseIV;
    }

    AbstractCredentialPublicKey() {
    }

    @Override
    public COSEKeyType getKeyType() {
        return this.keyType;
    }

    @Override
    public byte[] getKeyId() {
        return this.keyId;
    }

    @Override
    public COSEAlgorithmIdentifier getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public int[] getKeyOpts() {
        return this.keyOpts;
    }

    @Override
    public byte[] getBaseIV() {
        return this.baseIV;
    }

    @JsonIgnore
    private String getAlgorithmName() {
        return this.algorithm.getName();
    }

    @Override
    public boolean verifySignature(byte[] signature, byte[] data) {
        try {
            Signature verifier = Signature.getInstance(this.getAlgorithmName());
            verifier.initVerify(this.getPublicKey());
            verifier.update(data);
            return verifier.verify(signature);
        }
        catch (RuntimeException | InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            return false;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractCredentialPublicKey that = (AbstractCredentialPublicKey)o;
        return this.keyType == that.keyType && Arrays.equals(this.keyId, that.keyId) && this.algorithm == that.algorithm && Arrays.equals(this.keyOpts, that.keyOpts) && Arrays.equals(this.baseIV, that.baseIV);
    }

    public int hashCode() {
        int result = Objects.hash(new Object[]{this.keyType, this.algorithm});
        result = 31 * result + Arrays.hashCode(this.keyId);
        result = 31 * result + Arrays.hashCode(this.keyOpts);
        result = 31 * result + Arrays.hashCode(this.baseIV);
        return result;
    }
}

