/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j;

import com.webauthn4j.server.ServerProperty;
import java.util.Arrays;
import java.util.Objects;

public class WebAuthnRegistrationContext {
    private final byte[] collectedClientData;
    private final byte[] attestationObject;
    private final ServerProperty serverProperty;

    public WebAuthnRegistrationContext(byte[] collectedClientData, byte[] attestationObject, ServerProperty serverProperty) {
        this.collectedClientData = collectedClientData;
        this.attestationObject = attestationObject;
        this.serverProperty = serverProperty;
    }

    public byte[] getCollectedClientData() {
        return this.collectedClientData;
    }

    public byte[] getAttestationObject() {
        return this.attestationObject;
    }

    public ServerProperty getServerProperty() {
        return this.serverProperty;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebAuthnRegistrationContext that = (WebAuthnRegistrationContext)o;
        return Arrays.equals(this.collectedClientData, that.collectedClientData) && Arrays.equals(this.attestationObject, that.attestationObject) && Objects.equals(this.serverProperty, that.serverProperty);
    }

    public int hashCode() {
        int result = Objects.hash(this.serverProperty);
        result = 31 * result + Arrays.hashCode(this.collectedClientData);
        result = 31 * result + Arrays.hashCode(this.attestationObject);
        return result;
    }
}

