/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.server;

import com.webauthn4j.data.client.Origin;
import com.webauthn4j.server.OriginPredicate;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;

public class SimpleOriginPredicate
implements OriginPredicate {
    private final Set<Origin> origins;

    SimpleOriginPredicate(Set<Origin> origins) {
        this.origins = origins;
    }

    SimpleOriginPredicate(Origin origin) {
        this.origins = Collections.singleton(origin);
    }

    @Override
    public boolean test(Origin origin) {
        return this.origins.contains(origin);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleOriginPredicate that = (SimpleOriginPredicate)o;
        return Objects.equals(this.origins, that.origins);
    }

    public int hashCode() {
        return Objects.hashCode(this.origins);
    }

    public String toString() {
        return "SimpleOriginPredicate{origins=" + String.valueOf(this.origins) + "}";
    }
}

