/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.attestation.statement;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.webauthn4j.util.ArrayUtil;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import tools.jackson.databind.exc.InvalidFormatException;

public enum TPMISTAttest {
    TPM_ST_ATTEST_CERTIFY(new byte[]{-128, 23}),
    TPM_ST_ATTEST_QUOTE(new byte[]{-128, 24}),
    TPM_ST_ATTEST_SESSION_AUDIT(new byte[]{-128, 22}),
    TPM_ST_ATTEST_COMMAND_AUDIT(new byte[]{-128, 21}),
    TPM_ST_ATTEST_TIME(new byte[]{-128, 25}),
    TPM_ST_ATTEST_CREATION(new byte[]{-128, 26}),
    TPM_ST_ATTEST_NV(new byte[]{-128, 20});

    private final byte[] value;

    private TPMISTAttest(byte[] value) {
        this.value = value;
    }

    @NotNull
    public static TPMISTAttest create(@NotNull byte[] value) {
        if (Arrays.equals(value, TPMISTAttest.TPM_ST_ATTEST_CERTIFY.value)) {
            return TPM_ST_ATTEST_CERTIFY;
        }
        if (Arrays.equals(value, TPMISTAttest.TPM_ST_ATTEST_QUOTE.value)) {
            return TPM_ST_ATTEST_QUOTE;
        }
        if (Arrays.equals(value, TPMISTAttest.TPM_ST_ATTEST_SESSION_AUDIT.value)) {
            return TPM_ST_ATTEST_SESSION_AUDIT;
        }
        if (Arrays.equals(value, TPMISTAttest.TPM_ST_ATTEST_COMMAND_AUDIT.value)) {
            return TPM_ST_ATTEST_COMMAND_AUDIT;
        }
        if (Arrays.equals(value, TPMISTAttest.TPM_ST_ATTEST_TIME.value)) {
            return TPM_ST_ATTEST_TIME;
        }
        if (Arrays.equals(value, TPMISTAttest.TPM_ST_ATTEST_CREATION.value)) {
            return TPM_ST_ATTEST_CREATION;
        }
        if (Arrays.equals(value, TPMISTAttest.TPM_ST_ATTEST_NV.value)) {
            return TPM_ST_ATTEST_NV;
        }
        throw new IllegalArgumentException("value is out of range");
    }

    @JsonCreator
    @NotNull
    private static TPMISTAttest deserialize(@NotNull byte[] value) throws InvalidFormatException {
        try {
            return TPMISTAttest.create(value);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidFormatException(null, "value is out of range", (Object)value, TPMISTAttest.class);
        }
    }

    @JsonValue
    @NotNull
    public byte[] getValue() {
        return ArrayUtil.clone(this.value);
    }
}

