/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.converter.jackson.serializer.cbor;

import com.webauthn4j.util.exception.UnexpectedCheckedException;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import org.jetbrains.annotations.NotNull;
import tools.jackson.core.JsonGenerator;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.ser.std.StdSerializer;

public class CertPathSerializer
extends StdSerializer<CertPath> {
    public CertPathSerializer() {
        super(CertPath.class);
    }

    public void serialize(@NotNull CertPath value, @NotNull JsonGenerator gen, @NotNull SerializationContext provider) {
        try {
            gen.writeStartArray();
            for (Certificate certificate : value.getCertificates()) {
                gen.writeBinary(certificate.getEncoded());
            }
            gen.writeEndArray();
        }
        catch (CertificateEncodingException e) {
            throw new UnexpectedCheckedException(e);
        }
    }
}

