/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.converter.jackson.deserializer.json;

import com.webauthn4j.data.AuthenticationAlgorithm;
import org.jetbrains.annotations.NotNull;
import tools.jackson.core.JsonParser;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.deser.std.StdDeserializer;
import tools.jackson.databind.exc.InvalidFormatException;

public class AuthenticationAlgorithmFromStringDeserializer
extends StdDeserializer<AuthenticationAlgorithm> {
    protected AuthenticationAlgorithmFromStringDeserializer() {
        super(AuthenticationAlgorithm.class);
    }

    public AuthenticationAlgorithm deserialize(@NotNull JsonParser p, @NotNull DeserializationContext ctxt) {
        String value = p.getValueAsString();
        try {
            return AuthenticationAlgorithm.create(value);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidFormatException(null, "value is out of range", (Object)value, AuthenticationAlgorithm.class);
        }
    }
}

