/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.converter.jackson.deserializer.json;

import com.webauthn4j.data.AttachmentHint;
import org.jetbrains.annotations.NotNull;
import tools.jackson.core.JsonParser;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.deser.std.StdDeserializer;
import tools.jackson.databind.exc.InvalidFormatException;

public class AttachmentHintFromLongDeserializer
extends StdDeserializer<AttachmentHint> {
    public AttachmentHintFromLongDeserializer() {
        super(AttachmentHint.class);
    }

    public AttachmentHint deserialize(@NotNull JsonParser p, @NotNull DeserializationContext ctxt) {
        long value = p.getValueAsLong();
        try {
            return AttachmentHint.create(value);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidFormatException(null, "value is out of range", (Object)value, AttachmentHint.class);
        }
    }
}

