/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.converter.jackson;

import com.webauthn4j.converter.jackson.deserializer.json.AttachmentHintFromLongDeserializer;
import com.webauthn4j.converter.jackson.deserializer.json.AuthenticationAlgorithmFromIntDeserializer;
import com.webauthn4j.converter.jackson.deserializer.json.AuthenticatorAttestationTypeFromIntDeserializer;
import com.webauthn4j.converter.jackson.deserializer.json.ByteArrayBase64UrlDeserializer;
import com.webauthn4j.converter.jackson.deserializer.json.ChallengeDeserializer;
import com.webauthn4j.converter.jackson.deserializer.json.CredentialProtectionPolicyDeserializer;
import com.webauthn4j.converter.jackson.deserializer.json.JWSHeaderDeserializer;
import com.webauthn4j.converter.jackson.deserializer.json.KeyProtectionTypeFromIntDeserializer;
import com.webauthn4j.converter.jackson.deserializer.json.MatcherProtectionTypeFromIntDeserializer;
import com.webauthn4j.converter.jackson.deserializer.json.PublicKeyRepresentationFormatFromIntDeserializer;
import com.webauthn4j.converter.jackson.deserializer.json.TransactionConfirmationDisplayFromIntDeserializer;
import com.webauthn4j.converter.jackson.deserializer.json.UserVerificationMethodFromLongDeserializer;
import com.webauthn4j.converter.jackson.deserializer.json.X509CertificateDeserializer;
import com.webauthn4j.converter.jackson.serializer.json.AttachmentHintToLongSerializer;
import com.webauthn4j.converter.jackson.serializer.json.AuthenticationAlgorithmToIntSerializer;
import com.webauthn4j.converter.jackson.serializer.json.AuthenticatorAttestationTypeToIntSerializer;
import com.webauthn4j.converter.jackson.serializer.json.ByteArrayBase64UrlSerializer;
import com.webauthn4j.converter.jackson.serializer.json.ChallengeSerializer;
import com.webauthn4j.converter.jackson.serializer.json.CredentialProtectionPolicySerializer;
import com.webauthn4j.converter.jackson.serializer.json.JWSHeaderSerializer;
import com.webauthn4j.converter.jackson.serializer.json.KeyProtectionTypeToIntSerializer;
import com.webauthn4j.converter.jackson.serializer.json.MatcherProtectionTypeToIntSerializer;
import com.webauthn4j.converter.jackson.serializer.json.OriginSerializer;
import com.webauthn4j.converter.jackson.serializer.json.PublicKeyRepresentationFormatToIntSerializer;
import com.webauthn4j.converter.jackson.serializer.json.TransactionConfirmationDisplayToIntSerializer;
import com.webauthn4j.converter.jackson.serializer.json.UserVerificationMethodToLongSerializer;
import com.webauthn4j.converter.jackson.serializer.json.X509CertificateSerializer;
import com.webauthn4j.converter.util.ObjectConverter;
import com.webauthn4j.data.AttachmentHint;
import com.webauthn4j.data.AuthenticationAlgorithm;
import com.webauthn4j.data.AuthenticatorAttestationType;
import com.webauthn4j.data.KeyProtectionType;
import com.webauthn4j.data.MatcherProtectionType;
import com.webauthn4j.data.PublicKeyRepresentationFormat;
import com.webauthn4j.data.TransactionConfirmationDisplay;
import com.webauthn4j.data.UserVerificationMethod;
import com.webauthn4j.data.client.challenge.Challenge;
import com.webauthn4j.data.extension.CredentialProtectionPolicy;
import com.webauthn4j.data.jws.JWSHeader;
import com.webauthn4j.util.AssertUtil;
import java.security.cert.X509Certificate;
import org.jetbrains.annotations.NotNull;
import tools.jackson.databind.ValueDeserializer;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.module.SimpleModule;

public class WebAuthnJSONModule
extends SimpleModule {
    public WebAuthnJSONModule(@NotNull ObjectConverter objectConverter) {
        super("WebAuthnJSONModule");
        AssertUtil.notNull(objectConverter, "objectConverter must not be null");
        this.addDeserializer(AttachmentHint.class, (ValueDeserializer)new AttachmentHintFromLongDeserializer());
        this.addDeserializer(AuthenticatorAttestationType.class, (ValueDeserializer)new AuthenticatorAttestationTypeFromIntDeserializer());
        this.addDeserializer(AuthenticationAlgorithm.class, (ValueDeserializer)new AuthenticationAlgorithmFromIntDeserializer());
        this.addDeserializer(Challenge.class, (ValueDeserializer)new ChallengeDeserializer());
        this.addDeserializer(CredentialProtectionPolicy.class, (ValueDeserializer)new CredentialProtectionPolicyDeserializer());
        this.addDeserializer(JWSHeader.class, (ValueDeserializer)new JWSHeaderDeserializer());
        this.addDeserializer(KeyProtectionType.class, (ValueDeserializer)new KeyProtectionTypeFromIntDeserializer());
        this.addDeserializer(MatcherProtectionType.class, (ValueDeserializer)new MatcherProtectionTypeFromIntDeserializer());
        this.addDeserializer(PublicKeyRepresentationFormat.class, (ValueDeserializer)new PublicKeyRepresentationFormatFromIntDeserializer());
        this.addDeserializer(TransactionConfirmationDisplay.class, (ValueDeserializer)new TransactionConfirmationDisplayFromIntDeserializer());
        this.addDeserializer(UserVerificationMethod.class, (ValueDeserializer)new UserVerificationMethodFromLongDeserializer());
        this.addDeserializer(X509Certificate.class, (ValueDeserializer)new X509CertificateDeserializer());
        this.addDeserializer(byte[].class, (ValueDeserializer)new ByteArrayBase64UrlDeserializer());
        this.addSerializer(AttachmentHint.class, (ValueSerializer)new AttachmentHintToLongSerializer());
        this.addSerializer(AuthenticatorAttestationType.class, (ValueSerializer)new AuthenticatorAttestationTypeToIntSerializer());
        this.addSerializer(AuthenticationAlgorithm.class, (ValueSerializer)new AuthenticationAlgorithmToIntSerializer());
        this.addSerializer((ValueSerializer)new ChallengeSerializer());
        this.addSerializer((ValueSerializer)new CredentialProtectionPolicySerializer());
        this.addSerializer((ValueSerializer)new JWSHeaderSerializer());
        this.addSerializer((ValueSerializer)new KeyProtectionTypeToIntSerializer());
        this.addSerializer((ValueSerializer)new MatcherProtectionTypeToIntSerializer());
        this.addSerializer((ValueSerializer)new OriginSerializer());
        this.addSerializer(PublicKeyRepresentationFormat.class, (ValueSerializer)new PublicKeyRepresentationFormatToIntSerializer());
        this.addSerializer(TransactionConfirmationDisplay.class, (ValueSerializer)new TransactionConfirmationDisplayToIntSerializer());
        this.addSerializer(UserVerificationMethod.class, (ValueSerializer)new UserVerificationMethodToLongSerializer());
        this.addSerializer((ValueSerializer)new X509CertificateSerializer());
        this.addSerializer((ValueSerializer)new ByteArrayBase64UrlSerializer());
    }
}

