/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.extension.authenticator;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.webauthn4j.converter.jackson.deserializer.cbor.HMACSecretAuthenticatorInputDeserializer;
import com.webauthn4j.data.extension.CredentialProtectionPolicy;
import com.webauthn4j.data.extension.SingleValueExtensionInputBase;
import com.webauthn4j.data.extension.authenticator.AuthenticationExtensionAuthenticatorInput;
import com.webauthn4j.data.extension.authenticator.CredentialProtectionExtensionAuthenticatorInput;
import com.webauthn4j.data.extension.authenticator.ExtensionAuthenticatorInput;
import com.webauthn4j.data.extension.authenticator.HMACGetSecretAuthenticatorInput;
import com.webauthn4j.data.extension.authenticator.HMACSecretAuthenticationExtensionAuthenticatorInput;
import com.webauthn4j.data.extension.authenticator.HMACSecretRegistrationExtensionAuthenticatorInput;
import com.webauthn4j.data.extension.authenticator.RegistrationExtensionAuthenticatorInput;
import com.webauthn4j.data.extension.authenticator.UserVerificationMethodExtensionAuthenticatorInput;
import com.webauthn4j.util.AssertUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tools.jackson.databind.annotation.JsonDeserialize;

public class AuthenticationExtensionsAuthenticatorInputs<T extends ExtensionAuthenticatorInput> {
    private static final String KEY_UVM = "uvm";
    private static final String KEY_CRED_PROTECT = "credProtect";
    private static final String KEY_HMAC_SECRET = "hmac-secret";
    @JsonIgnore
    private final Map<String, Object> unknowns = new HashMap<String, Object>();
    @JsonProperty
    private Boolean uvm;
    @JsonProperty
    private CredentialProtectionPolicy credProtect;
    @JsonIgnore
    private Boolean hmacCreateSecret;
    @JsonIgnore
    private HMACGetSecretAuthenticatorInput hmacGetSecret;
    @JsonIgnore
    private Map<Class<? extends T>, T> extensions;

    @JsonSetter(value="hmac-secret")
    @JsonDeserialize(using=HMACSecretAuthenticatorInputDeserializer.class)
    private void setHMACSecret(Object hmacSecret) {
        if (hmacSecret instanceof Boolean) {
            this.hmacCreateSecret = (Boolean)hmacSecret;
            this.hmacGetSecret = null;
        } else {
            this.hmacCreateSecret = null;
            this.hmacGetSecret = (HMACGetSecretAuthenticatorInput)hmacSecret;
        }
    }

    @JsonAnyGetter
    private Map<String, Object> getUnknowns() {
        return Collections.unmodifiableMap(this.unknowns);
    }

    @JsonAnySetter
    private void setUnknowns(@NotNull String name, @Nullable Object value) {
        this.unknowns.put(name, value);
    }

    @JsonIgnore
    @NotNull
    public Set<String> getKeys() {
        HashSet<String> keys = new HashSet<String>();
        if (this.uvm != null) {
            keys.add(KEY_UVM);
        }
        if (this.credProtect != null) {
            keys.add(KEY_CRED_PROTECT);
        }
        if (this.hmacCreateSecret != null) {
            keys.add(KEY_HMAC_SECRET);
        }
        if (this.hmacGetSecret != null) {
            keys.add(KEY_HMAC_SECRET);
        }
        keys.addAll(this.getUnknownKeys());
        return keys;
    }

    @JsonIgnore
    @NotNull
    public Set<String> getUnknownKeys() {
        return this.unknowns.keySet();
    }

    @JsonIgnore
    @Nullable
    public Object getValue(String key) {
        switch (key) {
            case "uvm": {
                return this.uvm;
            }
            case "credProtect": {
                return this.credProtect;
            }
            case "hmac-secret": {
                return this.hmacCreateSecret != null ? this.hmacCreateSecret : this.hmacGetSecret;
            }
        }
        return this.unknowns.get(key);
    }

    @JsonIgnore
    @Nullable
    public Boolean getUvm() {
        return this.uvm;
    }

    @JsonIgnore
    @Nullable
    public CredentialProtectionPolicy getCredProtect() {
        return this.credProtect;
    }

    @JsonGetter(value="hmac-secret")
    @Nullable
    public Object getHMACSecret() {
        return this.hmacCreateSecret != null ? this.hmacCreateSecret : this.hmacGetSecret;
    }

    @JsonIgnore
    @Nullable
    public Boolean getHMACCreateSecret() {
        return this.hmacCreateSecret;
    }

    @JsonIgnore
    @Nullable
    public HMACGetSecretAuthenticatorInput getHMACGetSecret() {
        return this.hmacGetSecret;
    }

    @Nullable
    public <E extends T> E getExtension(@NotNull Class<E> tClass) {
        return (E)((ExtensionAuthenticatorInput)this.getExtensions().get(tClass));
    }

    @JsonIgnore
    @NotNull
    public Map<Class<? extends T>, T> getExtensions() {
        if (this.extensions == null) {
            HashMap<Class, SingleValueExtensionInputBase> map = new HashMap<Class, SingleValueExtensionInputBase>();
            if (this.uvm != null) {
                map.put(UserVerificationMethodExtensionAuthenticatorInput.class, new UserVerificationMethodExtensionAuthenticatorInput(this.uvm));
            }
            if (this.credProtect != null) {
                map.put(CredentialProtectionExtensionAuthenticatorInput.class, new CredentialProtectionExtensionAuthenticatorInput(this.credProtect));
            }
            if (this.hmacCreateSecret != null) {
                map.put(HMACSecretRegistrationExtensionAuthenticatorInput.class, new HMACSecretRegistrationExtensionAuthenticatorInput(this.hmacCreateSecret));
            }
            if (this.hmacGetSecret != null) {
                map.put(HMACSecretAuthenticationExtensionAuthenticatorInput.class, new HMACSecretAuthenticationExtensionAuthenticatorInput(this.hmacGetSecret));
            }
            this.extensions = Collections.unmodifiableMap(map);
        }
        return this.extensions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthenticationExtensionsAuthenticatorInputs that = (AuthenticationExtensionsAuthenticatorInputs)o;
        return Objects.equals(this.unknowns, that.unknowns) && Objects.equals(this.uvm, that.uvm) && this.credProtect == that.credProtect && Objects.equals(this.hmacCreateSecret, that.hmacCreateSecret) && Objects.equals(this.hmacGetSecret, that.hmacGetSecret) && Objects.equals(this.extensions, that.extensions);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AuthenticationExtensionsAuthenticatorInputs(");
        String entries = this.getExtensions().values().stream().map(t -> String.format("%s=%s", t.getIdentifier(), t)).collect(Collectors.joining(", "));
        builder.append(entries);
        String unknownsStr = this.getUnknowns().entrySet().stream().map(entry -> String.format("%s=%s", entry.getKey(), entry.getValue())).collect(Collectors.joining(", "));
        if (!unknownsStr.isEmpty()) {
            builder.append(", ");
            builder.append(unknownsStr);
        }
        builder.append(")");
        return builder.toString();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.unknowns, this.uvm, this.credProtect, this.hmacCreateSecret, this.hmacGetSecret, this.extensions});
    }

    public static class BuilderForAuthentication {
        private final Map<String, Object> unknowns = new HashMap<String, Object>();
        private Boolean uvm;
        private HMACGetSecretAuthenticatorInput hmacGetSecret;

        @NotNull
        public AuthenticationExtensionsAuthenticatorInputs<AuthenticationExtensionAuthenticatorInput> build() {
            AuthenticationExtensionsAuthenticatorInputs<AuthenticationExtensionAuthenticatorInput> instance = new AuthenticationExtensionsAuthenticatorInputs<AuthenticationExtensionAuthenticatorInput>();
            instance.uvm = this.uvm;
            instance.hmacGetSecret = this.hmacGetSecret;
            instance.unknowns.putAll(this.unknowns);
            return instance;
        }

        @NotNull
        public BuilderForAuthentication setUvm(@Nullable Boolean uvm) {
            this.uvm = uvm;
            return this;
        }

        @NotNull
        public BuilderForAuthentication setHMACGetSecret(@Nullable HMACGetSecretAuthenticatorInput hmacGetSecret) {
            this.hmacGetSecret = hmacGetSecret;
            return this;
        }

        @NotNull
        public BuilderForAuthentication set(@NotNull String key, @Nullable Object value) {
            AssertUtil.notNull(key, "key must not be null.");
            AssertUtil.notNull(value, "value must not be null.");
            this.unknowns.put(key, value);
            return this;
        }
    }

    public static class BuilderForRegistration {
        private final Map<String, Object> unknowns = new HashMap<String, Object>();
        private Boolean uvm;
        private CredentialProtectionPolicy credProtect;
        private Boolean hmacCreateSecret;

        @NotNull
        public AuthenticationExtensionsAuthenticatorInputs<RegistrationExtensionAuthenticatorInput> build() {
            AuthenticationExtensionsAuthenticatorInputs<RegistrationExtensionAuthenticatorInput> instance = new AuthenticationExtensionsAuthenticatorInputs<RegistrationExtensionAuthenticatorInput>();
            instance.uvm = this.uvm;
            instance.credProtect = this.credProtect;
            instance.hmacCreateSecret = this.hmacCreateSecret;
            instance.unknowns.putAll(this.unknowns);
            return instance;
        }

        @NotNull
        public BuilderForRegistration setUvm(@Nullable Boolean uvm) {
            this.uvm = uvm;
            return this;
        }

        @NotNull
        public BuilderForRegistration setCredProtect(@Nullable CredentialProtectionPolicy credProtect) {
            this.credProtect = credProtect;
            return this;
        }

        @NotNull
        public BuilderForRegistration setHMACCreateSecret(@Nullable Boolean hmacCreateSecret) {
            this.hmacCreateSecret = hmacCreateSecret;
            return this;
        }

        @NotNull
        public BuilderForRegistration set(@NotNull String key, @Nullable Object value) {
            AssertUtil.notNull(key, "key must not be null.");
            AssertUtil.notNull(value, "value must not be null.");
            this.unknowns.put(key, value);
            return this;
        }
    }
}

