/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.attestation.statement;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonValue;
import com.webauthn4j.data.SignatureAlgorithm;
import com.webauthn4j.data.attestation.statement.COSEKeyType;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tools.jackson.databind.exc.InvalidFormatException;

public class COSEAlgorithmIdentifier {
    public static final COSEAlgorithmIdentifier RS1;
    public static final COSEAlgorithmIdentifier RS256;
    public static final COSEAlgorithmIdentifier RS384;
    public static final COSEAlgorithmIdentifier RS512;
    public static final COSEAlgorithmIdentifier ES256;
    public static final COSEAlgorithmIdentifier ES384;
    public static final COSEAlgorithmIdentifier ES512;
    public static final COSEAlgorithmIdentifier EdDSA;
    public static final COSEAlgorithmIdentifier PS256;
    public static final COSEAlgorithmIdentifier PS384;
    public static final COSEAlgorithmIdentifier PS512;
    private static final Map<COSEAlgorithmIdentifier, COSEKeyType> keyTypeMap;
    private static final Map<COSEAlgorithmIdentifier, SignatureAlgorithm> algorithmMap;
    private static final Map<SignatureAlgorithm, COSEAlgorithmIdentifier> reverseAlgorithmMap;
    private final long value;

    COSEAlgorithmIdentifier(long value) {
        this.value = value;
    }

    @NotNull
    public static COSEAlgorithmIdentifier create(long value) {
        return new COSEAlgorithmIdentifier(value);
    }

    @NotNull
    public static COSEAlgorithmIdentifier create(@NotNull SignatureAlgorithm signatureAlgorithm) {
        COSEAlgorithmIdentifier coseAlgorithmIdentifier = reverseAlgorithmMap.get(signatureAlgorithm);
        if (coseAlgorithmIdentifier == null) {
            throw new IllegalArgumentException(String.format("SignatureAlgorithm %s is not supported.", signatureAlgorithm.getJcaName()));
        }
        return coseAlgorithmIdentifier;
    }

    @JsonCreator
    @NotNull
    private static COSEAlgorithmIdentifier deserialize(long value) throws InvalidFormatException {
        try {
            return COSEAlgorithmIdentifier.create(value);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidFormatException(null, "value is out of range", (Object)value, COSEAlgorithmIdentifier.class);
        }
    }

    @JsonValue
    public long getValue() {
        return this.value;
    }

    @JsonIgnore
    @NotNull
    public COSEKeyType getKeyType() {
        COSEKeyType coseKeyType = keyTypeMap.get(this);
        if (coseKeyType == null) {
            throw new IllegalArgumentException(String.format("COSEAlgorithmIdentifier %d is unknown.", this.getValue()));
        }
        return coseKeyType;
    }

    @NotNull
    public SignatureAlgorithm toSignatureAlgorithm() {
        SignatureAlgorithm signatureAlgorithm = algorithmMap.get(this);
        if (signatureAlgorithm == null) {
            throw new IllegalArgumentException(String.format("COSEAlgorithmIdentifier %d is unknown.", this.getValue()));
        }
        return signatureAlgorithm;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        COSEAlgorithmIdentifier that = (COSEAlgorithmIdentifier)o;
        return this.value == that.value;
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        if (this.value == COSEAlgorithmIdentifier.RS1.value) {
            return "RS1";
        }
        if (this.value == COSEAlgorithmIdentifier.RS256.value) {
            return "RS256";
        }
        if (this.value == COSEAlgorithmIdentifier.RS384.value) {
            return "RS384";
        }
        if (this.value == COSEAlgorithmIdentifier.RS512.value) {
            return "RS512";
        }
        if (this.value == COSEAlgorithmIdentifier.ES256.value) {
            return "ES256";
        }
        if (this.value == COSEAlgorithmIdentifier.ES384.value) {
            return "ES384";
        }
        if (this.value == COSEAlgorithmIdentifier.ES512.value) {
            return "ES512";
        }
        if (this.value == COSEAlgorithmIdentifier.EdDSA.value) {
            return "EdDSA";
        }
        if (this.value == COSEAlgorithmIdentifier.PS256.value) {
            return "PS256";
        }
        if (this.value == COSEAlgorithmIdentifier.PS384.value) {
            return "PS384";
        }
        if (this.value == COSEAlgorithmIdentifier.PS512.value) {
            return "PS512";
        }
        return String.format("Unknown COSEAlgorithmIdentifier(%d)", this.value);
    }

    static {
        keyTypeMap = new HashMap<COSEAlgorithmIdentifier, COSEKeyType>();
        algorithmMap = new HashMap<COSEAlgorithmIdentifier, SignatureAlgorithm>();
        reverseAlgorithmMap = new HashMap<SignatureAlgorithm, COSEAlgorithmIdentifier>();
        RS1 = new COSEAlgorithmIdentifier(-65535L);
        RS256 = new COSEAlgorithmIdentifier(-257L);
        RS384 = new COSEAlgorithmIdentifier(-258L);
        RS512 = new COSEAlgorithmIdentifier(-259L);
        ES256 = new COSEAlgorithmIdentifier(-7L);
        ES384 = new COSEAlgorithmIdentifier(-35L);
        ES512 = new COSEAlgorithmIdentifier(-36L);
        EdDSA = new COSEAlgorithmIdentifier(-8L);
        PS256 = new COSEAlgorithmIdentifier(-37L);
        PS384 = new COSEAlgorithmIdentifier(-38L);
        PS512 = new COSEAlgorithmIdentifier(-39L);
        keyTypeMap.put(ES256, COSEKeyType.EC2);
        keyTypeMap.put(ES384, COSEKeyType.EC2);
        keyTypeMap.put(ES512, COSEKeyType.EC2);
        keyTypeMap.put(EdDSA, COSEKeyType.OKP);
        keyTypeMap.put(RS1, COSEKeyType.RSA);
        keyTypeMap.put(RS256, COSEKeyType.RSA);
        keyTypeMap.put(RS384, COSEKeyType.RSA);
        keyTypeMap.put(RS512, COSEKeyType.RSA);
        keyTypeMap.put(PS256, COSEKeyType.RSA);
        keyTypeMap.put(PS384, COSEKeyType.RSA);
        keyTypeMap.put(PS512, COSEKeyType.RSA);
        algorithmMap.put(ES256, SignatureAlgorithm.ES256);
        algorithmMap.put(ES384, SignatureAlgorithm.ES384);
        algorithmMap.put(ES512, SignatureAlgorithm.ES512);
        algorithmMap.put(EdDSA, SignatureAlgorithm.Ed25519);
        algorithmMap.put(RS1, SignatureAlgorithm.RS1);
        algorithmMap.put(RS256, SignatureAlgorithm.RS256);
        algorithmMap.put(RS384, SignatureAlgorithm.RS384);
        algorithmMap.put(RS512, SignatureAlgorithm.RS512);
        algorithmMap.put(PS256, SignatureAlgorithm.PS256);
        algorithmMap.put(PS384, SignatureAlgorithm.PS384);
        algorithmMap.put(PS512, SignatureAlgorithm.PS512);
        for (Map.Entry<COSEAlgorithmIdentifier, SignatureAlgorithm> entry : algorithmMap.entrySet()) {
            reverseAlgorithmMap.put(entry.getValue(), entry.getKey());
        }
    }
}

