/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.converter.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.webauthn4j.converter.jackson.WebAuthnCBORModule;
import com.webauthn4j.converter.jackson.WebAuthnJSONModule;
import com.webauthn4j.converter.util.CborConverter;
import com.webauthn4j.converter.util.JsonConverter;
import com.webauthn4j.util.AssertUtil;
import org.jetbrains.annotations.NotNull;
import tools.jackson.databind.DeserializationFeature;
import tools.jackson.databind.JacksonModule;
import tools.jackson.databind.json.JsonMapper;
import tools.jackson.dataformat.cbor.CBORMapper;

public class ObjectConverter {
    JsonMapper jsonMapper;
    CBORMapper cborMapper;
    private final JsonConverter jsonConverter;
    private final CborConverter cborConverter;

    public ObjectConverter(@NotNull JsonMapper jsonMapper, @NotNull CBORMapper cborMapper) {
        AssertUtil.notNull(jsonMapper, "jsonMapper must not be null");
        AssertUtil.notNull(cborMapper, "cborMapper must not be null");
        this.jsonMapper = ObjectConverter.reconfigureJsonMapper(jsonMapper, this);
        this.cborMapper = ObjectConverter.reconfigureCborMapper(cborMapper, this);
        this.jsonConverter = new JsonConverter(this);
        this.cborConverter = new CborConverter(this);
    }

    public ObjectConverter() {
        this(new JsonMapper(), new CBORMapper());
    }

    private static JsonMapper reconfigureJsonMapper(@NotNull JsonMapper jsonMapper, @NotNull ObjectConverter objectConverter) {
        return ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)jsonMapper.rebuild().addModule((JacksonModule)new WebAuthnJSONModule(objectConverter))).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false)).changeDefaultPropertyInclusion(incl -> incl.withValueInclusion(JsonInclude.Include.NON_NULL))).build();
    }

    private static CBORMapper reconfigureCborMapper(@NotNull CBORMapper cborMapper, @NotNull ObjectConverter objectConverter) {
        return ((CBORMapper.Builder)((CBORMapper.Builder)((CBORMapper.Builder)cborMapper.rebuild().addModule((JacksonModule)new WebAuthnCBORModule(objectConverter))).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false)).changeDefaultPropertyInclusion(incl -> incl.withValueInclusion(JsonInclude.Include.NON_NULL))).build();
    }

    @Deprecated
    @NotNull
    public JsonConverter getJsonConverter() {
        return this.jsonConverter;
    }

    @Deprecated
    @NotNull
    public CborConverter getCborConverter() {
        return this.cborConverter;
    }

    @NotNull
    public JsonMapper getJsonMapper() {
        return this.jsonMapper;
    }

    @NotNull
    public CBORMapper getCborMapper() {
        return this.cborMapper;
    }
}

