/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.converter.jackson.serializer.json;

import com.webauthn4j.util.Base64Util;
import com.webauthn4j.util.exception.UnexpectedCheckedException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import org.jetbrains.annotations.NotNull;
import tools.jackson.core.JsonGenerator;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.ser.std.StdSerializer;

public class X509CertificateSerializer
extends StdSerializer<X509Certificate> {
    public X509CertificateSerializer() {
        super(X509Certificate.class);
    }

    public void serialize(@NotNull X509Certificate value, @NotNull JsonGenerator gen, @NotNull SerializationContext provider) {
        try {
            String str = Base64Util.encodeToString(value.getEncoded());
            gen.writeString(str);
        }
        catch (CertificateEncodingException e) {
            throw new UnexpectedCheckedException(e);
        }
    }
}

