/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.converter.jackson.serializer.cbor;

import com.webauthn4j.converter.AuthenticatorDataConverter;
import com.webauthn4j.converter.util.ObjectConverter;
import com.webauthn4j.data.attestation.authenticator.AuthenticatorData;
import com.webauthn4j.data.extension.authenticator.ExtensionAuthenticatorInput;
import com.webauthn4j.util.AssertUtil;
import org.jetbrains.annotations.NotNull;
import tools.jackson.core.JsonGenerator;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.ser.std.StdSerializer;

public class AuthenticatorDataSerializer
extends StdSerializer<AuthenticatorData<? extends ExtensionAuthenticatorInput>> {
    private final ObjectConverter objectConverter;

    public AuthenticatorDataSerializer(ObjectConverter objectConverter) {
        super(AuthenticatorData.class, false);
        AssertUtil.notNull(objectConverter, "objectConverter must not be null");
        this.objectConverter = objectConverter;
    }

    public void serialize(@NotNull AuthenticatorData<? extends ExtensionAuthenticatorInput> value, @NotNull JsonGenerator gen, @NotNull SerializationContext provider) {
        gen.writeBinary(new AuthenticatorDataConverter(this.objectConverter).convert(value));
    }
}

