/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.converter.jackson.deserializer.json;

import com.webauthn4j.data.jws.JWAIdentifier;
import com.webauthn4j.data.jws.JWSHeader;
import com.webauthn4j.util.Base64Util;
import com.webauthn4j.util.CertificateUtil;
import java.security.cert.CertPath;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import tools.jackson.core.JsonParser;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.deser.std.StdDeserializer;

public class JWSHeaderDeserializer
extends StdDeserializer<JWSHeader> {
    public JWSHeaderDeserializer() {
        super(JWSHeader.class);
    }

    public JWSHeader deserialize(@NotNull JsonParser p, @NotNull DeserializationContext ctxt) {
        JsonNode jsonNode = ctxt.readTree(p);
        JWAIdentifier alg = (JWAIdentifier)((Object)ctxt.readTreeAsValue(jsonNode.get("alg"), JWAIdentifier.class));
        JsonNode x5cNode = jsonNode.get("x5c");
        ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>();
        for (JsonNode node : x5cNode) {
            certificates.add(CertificateUtil.generateX509Certificate(Base64Util.decode(node.asString())));
        }
        CertPath x5c = CertificateUtil.generateCertPath(certificates);
        return new JWSHeader(alg, x5c);
    }
}

