/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.converter.jackson.deserializer.cbor;

import com.webauthn4j.util.CertificateUtil;
import java.security.cert.X509Certificate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tools.jackson.core.JsonParser;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.deser.std.StdDeserializer;

public class X509CertificateDeserializer
extends StdDeserializer<X509Certificate> {
    public X509CertificateDeserializer() {
        super(X509Certificate.class);
    }

    @Nullable
    public X509Certificate deserialize(@NotNull JsonParser p, @NotNull DeserializationContext ctxt) {
        byte[] value = p.getBinaryValue();
        if (value.length == 0) {
            return null;
        }
        return CertificateUtil.generateX509Certificate(value);
    }
}

