/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.converter.jackson.deserializer.cbor;

import com.webauthn4j.util.CertificateUtil;
import java.security.cert.CertPath;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import tools.jackson.core.JsonParser;
import tools.jackson.core.ObjectReadContext;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.deser.std.StdDeserializer;
import tools.jackson.databind.node.ArrayNode;

public class CertPathDeserializer
extends StdDeserializer<CertPath> {
    public CertPathDeserializer() {
        super(CertPath.class);
    }

    @NotNull
    public CertPath deserialize(@NotNull JsonParser p, @NotNull DeserializationContext ctxt) {
        ObjectReadContext objectReadContext = p.objectReadContext();
        ArrayNode node = (ArrayNode)objectReadContext.readTree(p);
        ArrayList<X509Certificate> list = new ArrayList<X509Certificate>();
        for (JsonNode item : node) {
            X509Certificate certificate = (X509Certificate)ctxt.readTreeAsValue(item, X509Certificate.class);
            list.add(certificate);
        }
        return CertificateUtil.generateCertPath(list);
    }
}

