/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.verifier.internal;

import com.webauthn4j.data.client.CollectedClientData;
import com.webauthn4j.data.client.Origin;
import com.webauthn4j.server.OriginPredicate;
import com.webauthn4j.server.ServerProperty;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.verifier.AuthenticationObject;
import com.webauthn4j.verifier.RegistrationObject;
import com.webauthn4j.verifier.exception.BadTopOriginException;
import com.webauthn4j.verifier.exception.CrossOriginException;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class TopOriginVerifier {
    private boolean forceBlockCrossOrigin = false;

    public void verify(@NotNull RegistrationObject registrationObject) {
        AssertUtil.notNull(registrationObject, "registrationObject must not be null");
        CollectedClientData collectedClientData = registrationObject.getCollectedClientData();
        ServerProperty serverProperty = registrationObject.getServerProperty();
        this.verify(collectedClientData, serverProperty);
    }

    public void verify(@NotNull AuthenticationObject authenticationObject) {
        AssertUtil.notNull(authenticationObject, "authenticationObject must not be null");
        CollectedClientData collectedClientData = authenticationObject.getCollectedClientData();
        ServerProperty serverProperty = authenticationObject.getServerProperty();
        this.verify(collectedClientData, serverProperty);
    }

    protected void verify(@NotNull CollectedClientData collectedClientData, @NotNull ServerProperty serverProperty) {
        AssertUtil.notNull(collectedClientData, "collectedClientData must not be null");
        AssertUtil.notNull(serverProperty, "serverProperty must not be null");
        Boolean clientCrossOrigin = collectedClientData.getCrossOrigin();
        Origin clientTopOrigin = collectedClientData.getTopOrigin();
        OriginPredicate expectedTopOriginPredicate = serverProperty.getTopOriginPredicate();
        if (Objects.equals(clientCrossOrigin, Boolean.TRUE)) {
            if (this.forceBlockCrossOrigin) {
                throw new CrossOriginException("Cross-origin request is prohibited. Relax AuthenticationDataVerifier config if necessary.");
            }
            if (expectedTopOriginPredicate == null || !expectedTopOriginPredicate.test(clientTopOrigin)) {
                throw new BadTopOriginException("The collectedClientData topOrigin '" + String.valueOf(clientTopOrigin) + "' doesn't match any of the preconfigured server topOrigin.");
            }
        }
    }

    @Deprecated
    public void setForceBlockCrossOrigin(boolean forceBlockCrossOrigin) {
        this.forceBlockCrossOrigin = forceBlockCrossOrigin;
    }

    @Deprecated
    public boolean isForceBlockCrossOrigin() {
        return this.forceBlockCrossOrigin;
    }
}

