/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.validator.attestation.trustworthiness.certpath;

import com.webauthn4j.anchor.TrustAnchorsResolver;
import com.webauthn4j.data.attestation.authenticator.AAGUID;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.validator.attestation.trustworthiness.certpath.CertPathTrustworthinessValidatorBase;
import java.security.cert.TrustAnchor;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;

public class TrustAnchorCertPathTrustworthinessValidator
extends CertPathTrustworthinessValidatorBase {
    private final TrustAnchorsResolver trustAnchorsResolver;

    public TrustAnchorCertPathTrustworthinessValidator(@NonNull TrustAnchorsResolver trustAnchorsResolver) {
        AssertUtil.notNull((Object)trustAnchorsResolver, (String)"trustAnchorsResolver must not be null");
        this.trustAnchorsResolver = trustAnchorsResolver;
    }

    @Override
    protected @NonNull Set<TrustAnchor> resolveTrustAnchors(@NonNull AAGUID aaguid) {
        AssertUtil.notNull((Object)aaguid, (String)"aaguid must not be null");
        return this.trustAnchorsResolver.resolve(aaguid);
    }
}

