/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.validator;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.cbor.CBORFactory;
import com.webauthn4j.data.AuthenticatorTransport;
import com.webauthn4j.data.attestation.AttestationObject;
import com.webauthn4j.data.client.CollectedClientData;
import com.webauthn4j.data.extension.client.AuthenticationExtensionsClientOutputs;
import com.webauthn4j.data.extension.client.RegistrationExtensionClientOutput;
import com.webauthn4j.server.ServerProperty;
import com.webauthn4j.util.ArrayUtil;
import com.webauthn4j.util.CollectionUtil;
import com.webauthn4j.util.JacksonUtil;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.Clock;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;

public class RegistrationObject {
    private static ObjectMapper cborMapper = new ObjectMapper((JsonFactory)new CBORFactory());
    private final AttestationObject attestationObject;
    private final byte[] attestationObjectBytes;
    private final CollectedClientData collectedClientData;
    private final byte[] collectedClientDataBytes;
    private final AuthenticationExtensionsClientOutputs<RegistrationExtensionClientOutput> clientExtensions;
    private final Set<AuthenticatorTransport> transports;
    private final ServerProperty serverProperty;
    private final LocalDateTime timestamp;

    public RegistrationObject(AttestationObject attestationObject, byte[] attestationObjectBytes, CollectedClientData collectedClientData, byte[] collectedClientDataBytes, AuthenticationExtensionsClientOutputs<RegistrationExtensionClientOutput> clientExtensions, Set<AuthenticatorTransport> transports, ServerProperty serverProperty, LocalDateTime timestamp) {
        this.attestationObject = attestationObject;
        this.attestationObjectBytes = ArrayUtil.clone((byte[])attestationObjectBytes);
        this.collectedClientData = collectedClientData;
        this.collectedClientDataBytes = ArrayUtil.clone((byte[])collectedClientDataBytes);
        this.clientExtensions = clientExtensions;
        this.transports = CollectionUtil.unmodifiableSet(transports);
        this.serverProperty = serverProperty;
        this.timestamp = timestamp;
    }

    public RegistrationObject(AttestationObject attestationObject, byte[] attestationObjectBytes, CollectedClientData collectedClientData, byte[] collectedClientDataBytes, AuthenticationExtensionsClientOutputs<RegistrationExtensionClientOutput> clientExtensions, Set<AuthenticatorTransport> transports, ServerProperty serverProperty) {
        this(attestationObject, attestationObjectBytes, collectedClientData, collectedClientDataBytes, clientExtensions, transports, serverProperty, LocalDateTime.now(Clock.systemUTC()));
    }

    public AttestationObject getAttestationObject() {
        return this.attestationObject;
    }

    public byte[] getAttestationObjectBytes() {
        return ArrayUtil.clone((byte[])this.attestationObjectBytes);
    }

    public byte[] getAuthenticatorDataBytes() {
        return RegistrationObject.extractAuthenticatorData(this.attestationObjectBytes);
    }

    public CollectedClientData getCollectedClientData() {
        return this.collectedClientData;
    }

    public byte[] getCollectedClientDataBytes() {
        return ArrayUtil.clone((byte[])this.collectedClientDataBytes);
    }

    public AuthenticationExtensionsClientOutputs<RegistrationExtensionClientOutput> getClientExtensions() {
        return this.clientExtensions;
    }

    public Set<AuthenticatorTransport> getTransports() {
        return this.transports;
    }

    public ServerProperty getServerProperty() {
        return this.serverProperty;
    }

    public LocalDateTime getTimestamp() {
        return this.timestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegistrationObject that = (RegistrationObject)o;
        return Objects.equals(this.attestationObject, that.attestationObject) && Arrays.equals(this.attestationObjectBytes, that.attestationObjectBytes) && Objects.equals(this.collectedClientData, that.collectedClientData) && Arrays.equals(this.collectedClientDataBytes, that.collectedClientDataBytes) && Objects.equals(this.clientExtensions, that.clientExtensions) && Objects.equals(this.transports, that.transports) && Objects.equals(this.serverProperty, that.serverProperty) && Objects.equals(this.timestamp, that.timestamp);
    }

    public int hashCode() {
        int result = Objects.hash(this.attestationObject, this.collectedClientData, this.clientExtensions, this.transports, this.serverProperty, this.timestamp);
        result = 31 * result + Arrays.hashCode(this.attestationObjectBytes);
        result = 31 * result + Arrays.hashCode(this.collectedClientDataBytes);
        return result;
    }

    private static byte[] extractAuthenticatorData(byte[] attestationObject) {
        try {
            return JacksonUtil.binaryValue((JsonNode)cborMapper.readTree(attestationObject).get("authData"));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

