/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.attestation.statement;

import com.webauthn4j.data.attestation.statement.TPMIAlgHash;
import com.webauthn4j.util.ArrayUtil;
import com.webauthn4j.util.UnsignedNumberUtil;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;

public class TPMTHA
implements Serializable {
    private TPMIAlgHash hashAlg;
    private byte[] digest;

    public TPMTHA(TPMIAlgHash hashAlg, byte[] digest) {
        this.hashAlg = hashAlg;
        this.digest = digest;
    }

    public TPMIAlgHash getHashAlg() {
        return this.hashAlg;
    }

    public byte[] getDigest() {
        return ArrayUtil.clone((byte[])this.digest);
    }

    public byte[] getBytes() {
        ByteBuffer buffer = ByteBuffer.allocate(2 + this.digest.length);
        buffer.put(UnsignedNumberUtil.toBytes((int)this.hashAlg.getValue()));
        buffer.put(this.digest);
        return buffer.array();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TPMTHA tpmtha = (TPMTHA)o;
        return this.hashAlg == tpmtha.hashAlg && Arrays.equals(this.digest, tpmtha.digest);
    }

    public int hashCode() {
        int result = Objects.hash(new Object[]{this.hashAlg});
        result = 31 * result + Arrays.hashCode(this.digest);
        return result;
    }
}

