/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.webauthn4j.data.AttestationConveyancePreference;
import com.webauthn4j.data.AuthenticatorSelectionCriteria;
import com.webauthn4j.data.PublicKeyCredentialDescriptor;
import com.webauthn4j.data.PublicKeyCredentialHints;
import com.webauthn4j.data.PublicKeyCredentialParameters;
import com.webauthn4j.data.PublicKeyCredentialRpEntity;
import com.webauthn4j.data.PublicKeyCredentialUserEntity;
import com.webauthn4j.data.client.challenge.Challenge;
import com.webauthn4j.data.extension.client.AuthenticationExtensionsClientInputs;
import com.webauthn4j.data.extension.client.RegistrationExtensionClientInput;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.util.CollectionUtil;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PublicKeyCredentialCreationOptions {
    private final PublicKeyCredentialRpEntity rp;
    private final PublicKeyCredentialUserEntity user;
    private final Challenge challenge;
    private final List<PublicKeyCredentialParameters> pubKeyCredParams;
    private final Long timeout;
    private final List<PublicKeyCredentialDescriptor> excludeCredentials;
    private final AuthenticatorSelectionCriteria authenticatorSelection;
    private final List<PublicKeyCredentialHints> hints;
    private final AttestationConveyancePreference attestation;
    private final AuthenticationExtensionsClientInputs<RegistrationExtensionClientInput> extensions;

    @JsonCreator
    public PublicKeyCredentialCreationOptions(@JsonProperty(value="rp") @NotNull PublicKeyCredentialRpEntity rp, @JsonProperty(value="user") @NotNull PublicKeyCredentialUserEntity user, @JsonProperty(value="challenge") @NotNull Challenge challenge, @JsonProperty(value="pubKeyCredParams") @NotNull List<PublicKeyCredentialParameters> pubKeyCredParams, @JsonProperty(value="timeout") @Nullable Long timeout, @JsonProperty(value="excludeCredentials") @Nullable List<PublicKeyCredentialDescriptor> excludeCredentials, @JsonProperty(value="authenticatorSelection") @Nullable AuthenticatorSelectionCriteria authenticatorSelection, @JsonProperty(value="hints") @Nullable List<PublicKeyCredentialHints> hints, @JsonProperty(value="attestation") @Nullable AttestationConveyancePreference attestation, @JsonProperty(value="extensions") @Nullable AuthenticationExtensionsClientInputs<RegistrationExtensionClientInput> extensions) {
        AssertUtil.notNull((Object)rp, (String)"rp must not be null");
        AssertUtil.notNull((Object)user, (String)"user must not be null");
        AssertUtil.notNull((Object)challenge, (String)"challenge must not be null");
        AssertUtil.notNull(pubKeyCredParams, (String)"pubKeyCredParams must not be null");
        this.rp = rp;
        this.user = user;
        this.challenge = challenge;
        this.pubKeyCredParams = CollectionUtil.unmodifiableList(pubKeyCredParams);
        this.timeout = timeout;
        this.excludeCredentials = CollectionUtil.unmodifiableList(excludeCredentials);
        this.authenticatorSelection = authenticatorSelection;
        this.hints = hints;
        this.attestation = attestation;
        this.extensions = extensions;
    }

    public PublicKeyCredentialCreationOptions(@JsonProperty(value="rp") @NotNull PublicKeyCredentialRpEntity rp, @JsonProperty(value="user") @NotNull PublicKeyCredentialUserEntity user, @JsonProperty(value="challenge") @NotNull Challenge challenge, @JsonProperty(value="pubKeyCredParams") @NotNull List<PublicKeyCredentialParameters> pubKeyCredParams, @JsonProperty(value="timeout") @Nullable Long timeout, @JsonProperty(value="excludeCredentials") @Nullable List<PublicKeyCredentialDescriptor> excludeCredentials, @JsonProperty(value="authenticatorSelection") @Nullable AuthenticatorSelectionCriteria authenticatorSelection, @JsonProperty(value="attestation") @Nullable AttestationConveyancePreference attestation, @JsonProperty(value="extensions") @Nullable AuthenticationExtensionsClientInputs<RegistrationExtensionClientInput> extensions) {
        this(rp, user, challenge, pubKeyCredParams, timeout, excludeCredentials, authenticatorSelection, null, attestation, extensions);
    }

    public PublicKeyCredentialCreationOptions(@NotNull PublicKeyCredentialRpEntity rp, @NotNull PublicKeyCredentialUserEntity user, @NotNull Challenge challenge, @NotNull List<PublicKeyCredentialParameters> pubKeyCredParams) {
        this(rp, user, challenge, pubKeyCredParams, null, Collections.emptyList(), null, null, null, null);
    }

    @NotNull
    public PublicKeyCredentialRpEntity getRp() {
        return this.rp;
    }

    @NotNull
    public PublicKeyCredentialUserEntity getUser() {
        return this.user;
    }

    @NotNull
    public Challenge getChallenge() {
        return this.challenge;
    }

    @NotNull
    public List<PublicKeyCredentialParameters> getPubKeyCredParams() {
        return this.pubKeyCredParams;
    }

    @Nullable
    public Long getTimeout() {
        return this.timeout;
    }

    @Nullable
    public List<PublicKeyCredentialDescriptor> getExcludeCredentials() {
        return this.excludeCredentials;
    }

    @Nullable
    public AuthenticatorSelectionCriteria getAuthenticatorSelection() {
        return this.authenticatorSelection;
    }

    @Nullable
    public List<PublicKeyCredentialHints> getHints() {
        return this.hints;
    }

    @Nullable
    public AttestationConveyancePreference getAttestation() {
        return this.attestation;
    }

    @Nullable
    public AuthenticationExtensionsClientInputs<RegistrationExtensionClientInput> getExtensions() {
        return this.extensions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PublicKeyCredentialCreationOptions that = (PublicKeyCredentialCreationOptions)o;
        return Objects.equals(this.rp, that.rp) && Objects.equals(this.user, that.user) && Objects.equals(this.challenge, that.challenge) && Objects.equals(this.pubKeyCredParams, that.pubKeyCredParams) && Objects.equals(this.timeout, that.timeout) && Objects.equals(this.excludeCredentials, that.excludeCredentials) && Objects.equals(this.authenticatorSelection, that.authenticatorSelection) && Objects.equals(this.hints, that.hints) && Objects.equals(this.attestation, that.attestation) && Objects.equals(this.extensions, that.extensions);
    }

    public int hashCode() {
        return Objects.hash(this.rp, this.user, this.challenge, this.pubKeyCredParams, this.timeout, this.excludeCredentials, this.authenticatorSelection, this.hints, this.attestation, this.extensions);
    }

    public String toString() {
        return "PublicKeyCredentialCreationOptions(rp=" + String.valueOf(this.rp) + ", user=" + String.valueOf(this.user) + ", challenge=" + String.valueOf(this.challenge) + ", pubKeyCredParams=" + String.valueOf(this.pubKeyCredParams) + ", timeout=" + this.timeout + ", excludeCredentials=" + String.valueOf(this.excludeCredentials) + ", authenticatorSelection=" + String.valueOf(this.authenticatorSelection) + ", hints=" + String.valueOf(this.hints) + ", attestation=" + String.valueOf(this.attestation) + ", extensions=" + String.valueOf(this.extensions) + ")";
    }
}

