/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j;

import com.fasterxml.jackson.core.type.TypeReference;
import com.webauthn4j.converter.AttestationObjectConverter;
import com.webauthn4j.converter.AuthenticationExtensionsClientOutputsConverter;
import com.webauthn4j.converter.AuthenticatorTransportConverter;
import com.webauthn4j.converter.CollectedClientDataConverter;
import com.webauthn4j.converter.exception.DataConversionException;
import com.webauthn4j.converter.util.ObjectConverter;
import com.webauthn4j.data.AuthenticatorAttestationResponse;
import com.webauthn4j.data.AuthenticatorTransport;
import com.webauthn4j.data.PublicKeyCredential;
import com.webauthn4j.data.RegistrationData;
import com.webauthn4j.data.RegistrationParameters;
import com.webauthn4j.data.RegistrationRequest;
import com.webauthn4j.data.attestation.AttestationObject;
import com.webauthn4j.data.client.CollectedClientData;
import com.webauthn4j.data.extension.client.AuthenticationExtensionsClientOutputs;
import com.webauthn4j.data.extension.client.RegistrationExtensionClientOutput;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.verifier.CustomRegistrationVerifier;
import com.webauthn4j.verifier.RegistrationDataVerifier;
import com.webauthn4j.verifier.attestation.statement.AttestationStatementVerifier;
import com.webauthn4j.verifier.attestation.statement.androidkey.NullAndroidKeyAttestationStatementVerifier;
import com.webauthn4j.verifier.attestation.statement.androidsafetynet.NullAndroidSafetyNetAttestationStatementVerifier;
import com.webauthn4j.verifier.attestation.statement.apple.NullAppleAnonymousAttestationStatementVerifier;
import com.webauthn4j.verifier.attestation.statement.none.NoneAttestationStatementVerifier;
import com.webauthn4j.verifier.attestation.statement.packed.NullPackedAttestationStatementVerifier;
import com.webauthn4j.verifier.attestation.statement.tpm.NullTPMAttestationStatementVerifier;
import com.webauthn4j.verifier.attestation.statement.u2f.NullFIDOU2FAttestationStatementVerifier;
import com.webauthn4j.verifier.attestation.trustworthiness.certpath.CertPathTrustworthinessVerifier;
import com.webauthn4j.verifier.attestation.trustworthiness.certpath.NullCertPathTrustworthinessVerifier;
import com.webauthn4j.verifier.attestation.trustworthiness.self.NullSelfAttestationTrustworthinessVerifier;
import com.webauthn4j.verifier.attestation.trustworthiness.self.SelfAttestationTrustworthinessVerifier;
import com.webauthn4j.verifier.exception.VerificationException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebAuthnRegistrationManager {
    private final Logger logger = LoggerFactory.getLogger(WebAuthnRegistrationManager.class);
    private final CollectedClientDataConverter collectedClientDataConverter;
    private final AttestationObjectConverter attestationObjectConverter;
    private final AuthenticatorTransportConverter authenticatorTransportConverter;
    private final AuthenticationExtensionsClientOutputsConverter authenticationExtensionsClientOutputsConverter;
    private final RegistrationDataVerifier registrationDataVerifier;
    private final ObjectConverter objectConverter;

    public WebAuthnRegistrationManager(@NotNull List<AttestationStatementVerifier> attestationStatementVerifiers, @NotNull CertPathTrustworthinessVerifier certPathTrustworthinessVerifier, @NotNull SelfAttestationTrustworthinessVerifier selfAttestationTrustworthinessVerifier, @NotNull List<CustomRegistrationVerifier> customRegistrationVerifiers, @NotNull ObjectConverter objectConverter) {
        AssertUtil.notNull(attestationStatementVerifiers, (String)"attestationStatementVerifiers must not be null");
        AssertUtil.notNull((Object)certPathTrustworthinessVerifier, (String)"certPathTrustworthinessVerifier must not be null");
        AssertUtil.notNull((Object)selfAttestationTrustworthinessVerifier, (String)"selfAttestationTrustworthinessVerifier must not be null");
        AssertUtil.notNull(customRegistrationVerifiers, (String)"customRegistrationVerifiers must not be null");
        AssertUtil.notNull((Object)objectConverter, (String)"objectConverter must not be null");
        this.registrationDataVerifier = new RegistrationDataVerifier(attestationStatementVerifiers, certPathTrustworthinessVerifier, selfAttestationTrustworthinessVerifier, customRegistrationVerifiers, objectConverter);
        this.collectedClientDataConverter = new CollectedClientDataConverter(objectConverter);
        this.attestationObjectConverter = new AttestationObjectConverter(objectConverter);
        this.authenticatorTransportConverter = new AuthenticatorTransportConverter();
        this.authenticationExtensionsClientOutputsConverter = new AuthenticationExtensionsClientOutputsConverter(objectConverter);
        this.objectConverter = objectConverter;
    }

    public WebAuthnRegistrationManager(@NotNull List<AttestationStatementVerifier> attestationStatementVerifiers, @NotNull CertPathTrustworthinessVerifier certPathTrustworthinessVerifier, @NotNull SelfAttestationTrustworthinessVerifier selfAttestationTrustworthinessVerifier, @NotNull List<CustomRegistrationVerifier> customRegistrationVerifiers) {
        this(attestationStatementVerifiers, certPathTrustworthinessVerifier, selfAttestationTrustworthinessVerifier, customRegistrationVerifiers, new ObjectConverter());
    }

    public WebAuthnRegistrationManager(@NotNull List<AttestationStatementVerifier> attestationStatementVerifiers, @NotNull CertPathTrustworthinessVerifier certPathTrustworthinessVerifier, @NotNull SelfAttestationTrustworthinessVerifier selfAttestationTrustworthinessVerifier, @NotNull ObjectConverter objectConverter) {
        this(attestationStatementVerifiers, certPathTrustworthinessVerifier, selfAttestationTrustworthinessVerifier, Collections.emptyList(), objectConverter);
    }

    public WebAuthnRegistrationManager(@NotNull List<AttestationStatementVerifier> attestationStatementVerifiers, @NotNull CertPathTrustworthinessVerifier certPathTrustworthinessVerifier, @NotNull SelfAttestationTrustworthinessVerifier selfAttestationTrustworthinessVerifier) {
        this(attestationStatementVerifiers, certPathTrustworthinessVerifier, selfAttestationTrustworthinessVerifier, Collections.emptyList());
    }

    @NotNull
    public static WebAuthnRegistrationManager createNonStrictWebAuthnRegistrationManager() {
        ObjectConverter objectConverter = new ObjectConverter();
        return WebAuthnRegistrationManager.createNonStrictWebAuthnRegistrationManager(objectConverter);
    }

    @NotNull
    public static WebAuthnRegistrationManager createNonStrictWebAuthnRegistrationManager(@NotNull ObjectConverter objectConverter) {
        return new WebAuthnRegistrationManager(Arrays.asList(new NoneAttestationStatementVerifier(), new NullFIDOU2FAttestationStatementVerifier(), new NullPackedAttestationStatementVerifier(), new NullTPMAttestationStatementVerifier(), new NullAndroidKeyAttestationStatementVerifier(), new NullAndroidSafetyNetAttestationStatementVerifier(), new NullAppleAnonymousAttestationStatementVerifier()), (CertPathTrustworthinessVerifier)new NullCertPathTrustworthinessVerifier(), (SelfAttestationTrustworthinessVerifier)new NullSelfAttestationTrustworthinessVerifier(), objectConverter);
    }

    @NotNull
    public RegistrationData parse(@NotNull String registrationResponseJSON) {
        PublicKeyCredential<AuthenticatorAttestationResponse, RegistrationExtensionClientOutput> publicKeyCredential = this.objectConverter.getJsonConverter().readValue(registrationResponseJSON, new TypeReference<PublicKeyCredential<AuthenticatorAttestationResponse, RegistrationExtensionClientOutput>>(){});
        return this.toRegistrationData(publicKeyCredential);
    }

    @NotNull
    public RegistrationData parse(@NotNull InputStream registrationResponseJSON) {
        PublicKeyCredential<AuthenticatorAttestationResponse, RegistrationExtensionClientOutput> publicKeyCredential = this.objectConverter.getJsonConverter().readValue(registrationResponseJSON, new TypeReference<PublicKeyCredential<AuthenticatorAttestationResponse, RegistrationExtensionClientOutput>>(){});
        return this.toRegistrationData(publicKeyCredential);
    }

    @NotNull
    private RegistrationData toRegistrationData(@NotNull PublicKeyCredential<AuthenticatorAttestationResponse, RegistrationExtensionClientOutput> publicKeyCredential) {
        byte[] attestationObjectBytes = publicKeyCredential.getResponse().getAttestationObject();
        AttestationObject attestationObject = attestationObjectBytes == null ? null : this.attestationObjectConverter.convert(attestationObjectBytes);
        byte[] clientDataBytes = publicKeyCredential.getResponse().getClientDataJSON();
        CollectedClientData collectedClientData = clientDataBytes == null ? null : this.collectedClientDataConverter.convert(clientDataBytes);
        return new RegistrationData(attestationObject, attestationObjectBytes, collectedClientData, clientDataBytes, publicKeyCredential.getClientExtensionResults(), publicKeyCredential.getResponse().getTransports());
    }

    @NotNull
    public RegistrationData parse(@NotNull RegistrationRequest registrationRequest) throws DataConversionException {
        AssertUtil.notNull((Object)registrationRequest, (String)"registrationRequest must not be null");
        byte[] clientDataBytes = registrationRequest.getClientDataJSON();
        byte[] attestationObjectBytes = registrationRequest.getAttestationObject();
        this.logger.trace("Parse: {}", (Object)registrationRequest);
        CollectedClientData collectedClientData = clientDataBytes == null ? null : this.collectedClientDataConverter.convert(clientDataBytes);
        AttestationObject attestationObject = attestationObjectBytes == null ? null : this.attestationObjectConverter.convert(attestationObjectBytes);
        Set<AuthenticatorTransport> transports = registrationRequest.getTransports() == null ? null : this.authenticatorTransportConverter.convertSet(registrationRequest.getTransports());
        AuthenticationExtensionsClientOutputs<RegistrationExtensionClientOutput> clientExtensions = registrationRequest.getClientExtensionsJSON() == null ? null : this.authenticationExtensionsClientOutputsConverter.convert(registrationRequest.getClientExtensionsJSON());
        return new RegistrationData(attestationObject, attestationObjectBytes, collectedClientData, clientDataBytes, clientExtensions, transports);
    }

    @NotNull
    public RegistrationData verify(@NotNull String registrationResponseJSON, @NotNull RegistrationParameters registrationParameters) {
        RegistrationData registrationData = this.parse(registrationResponseJSON);
        return this.verify(registrationData, registrationParameters);
    }

    @NotNull
    public RegistrationData verify(@NotNull InputStream registrationResponseJSON, @NotNull RegistrationParameters registrationParameters) {
        RegistrationData registrationData = this.parse(registrationResponseJSON);
        return this.verify(registrationData, registrationParameters);
    }

    @NotNull
    public RegistrationData verify(@NotNull RegistrationRequest registrationRequest, @NotNull RegistrationParameters registrationParameters) throws DataConversionException, VerificationException {
        RegistrationData registrationData = this.parse(registrationRequest);
        return this.verify(registrationData, registrationParameters);
    }

    @NotNull
    public RegistrationData verify(@NotNull RegistrationData registrationData, @NotNull RegistrationParameters registrationParameters) throws VerificationException {
        this.logger.trace("Verify: {}, {}", (Object)registrationData, (Object)registrationParameters);
        this.registrationDataVerifier.verify(registrationData, registrationParameters);
        return registrationData;
    }

    @NotNull
    public RegistrationDataVerifier getRegistrationDataVerifier() {
        return this.registrationDataVerifier;
    }
}

