/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.webauthn4j.util.AssertUtil;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class PublicKeyCredentialHints {
    public static final PublicKeyCredentialHints SECURITY_KEY = new PublicKeyCredentialHints("security-key");
    public static final PublicKeyCredentialHints CLIENT_DEVICE = new PublicKeyCredentialHints("client-device");
    public static final PublicKeyCredentialHints HYBRID = new PublicKeyCredentialHints("hybrid");
    private final String value;

    private PublicKeyCredentialHints(String value) {
        this.value = value;
    }

    @JsonCreator
    @NotNull
    public static PublicKeyCredentialHints create(@NotNull String value) {
        AssertUtil.notNull((Object)value, (String)"value must not be null.");
        switch (value) {
            case "security-key": {
                return SECURITY_KEY;
            }
            case "client-device": {
                return CLIENT_DEVICE;
            }
            case "hybrid": {
                return HYBRID;
            }
        }
        return new PublicKeyCredentialHints(value);
    }

    @JsonValue
    @NotNull
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PublicKeyCredentialHints that = (PublicKeyCredentialHints)o;
        return this.value.equals(that.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }
}

