/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.extension;

import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class SingleValueExtensionBase<T> {
    private final T value;

    protected SingleValueExtensionBase(@NonNull T value) {
        this.value = value;
    }

    public T getValue(@NonNull String key) {
        if (!key.equals(this.getIdentifier())) {
            throw new IllegalArgumentException(String.format("%s is the only valid key.", this.getIdentifier()));
        }
        return this.value;
    }

    protected abstract @NonNull String getIdentifier();

    public @NonNull T getValue() {
        return this.value;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingleValueExtensionBase that = (SingleValueExtensionBase)o;
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return this.value.toString();
    }
}

