/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.attestation.statement;

import java.nio.ByteBuffer;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class TPMAObject {
    public static final int FIXED_TPM_BIT = 2;
    public static final int ST_CLEAR_BIT = 4;
    public static final int FIXED_PARENT_BIT = 16;
    public static final int SENSITIVE_DATA_ORIGIN_BIT = 32;
    public static final int USER_WITH_AUTH_BIT = 64;
    public static final int ADMIN_WITH_POLICY_BIT = 128;
    public static final int NO_DA_BIT = 1024;
    public static final int ENCRYPTED_DUPLICATION_BIT = 2048;
    public static final int RESTRICTED_BIT = 65536;
    public static final int DECRYPT_BIT = 131072;
    public static final int SIGN_ENCRYPT_BIT = 262144;
    private final int value;

    public TPMAObject(int value) {
        this.value = value;
    }

    public boolean isFixedTPM() {
        return (this.value & 2) != 0;
    }

    public boolean isStClear() {
        return (this.value & 4) != 0;
    }

    public boolean isFixedParent() {
        return (this.value & 0x10) != 0;
    }

    public boolean isSensitiveDataOrigin() {
        return (this.value & 0x20) != 0;
    }

    public boolean isUserWithAuth() {
        return (this.value & 0x40) != 0;
    }

    public boolean isAdminWithPolicy() {
        return (this.value & 0x80) != 0;
    }

    public boolean isNoDA() {
        return (this.value & 0x400) != 0;
    }

    public boolean isEncryptedDuplication() {
        return (this.value & 0x800) != 0;
    }

    public boolean isRestricted() {
        return (this.value & 0x10000) != 0;
    }

    public boolean isDecrypt() {
        return (this.value & 0x20000) != 0;
    }

    public boolean isSignEncrypt() {
        return (this.value & 0x40000) != 0;
    }

    public @NonNull byte[] getBytes() {
        return ByteBuffer.allocate(4).putInt(this.value).array();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TPMAObject that = (TPMAObject)o;
        return this.value == that.value;
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }
}

