/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.attestation.authenticator;

import com.webauthn4j.data.attestation.authenticator.AAGUID;
import com.webauthn4j.data.attestation.authenticator.COSEKey;
import com.webauthn4j.util.ArrayUtil;
import com.webauthn4j.util.AssertUtil;
import java.util.Arrays;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class AttestedCredentialData {
    private final AAGUID aaguid;
    private final byte[] credentialId;
    private final COSEKey coseKey;

    public AttestedCredentialData(@NonNull AAGUID aaguid, @NonNull byte[] credentialId, @NonNull COSEKey coseKey) {
        AssertUtil.notNull((Object)aaguid, (String)"aaguid must not be null");
        AssertUtil.notNull((Object)credentialId, (String)"credentialId must not be null");
        AssertUtil.notNull((Object)coseKey, (String)"coseKey must not be null");
        this.aaguid = aaguid;
        this.credentialId = credentialId;
        this.coseKey = coseKey;
    }

    private AttestedCredentialData() {
        this.aaguid = null;
        this.credentialId = null;
        this.coseKey = null;
    }

    public @NonNull AAGUID getAaguid() {
        return this.aaguid;
    }

    public @NonNull byte[] getCredentialId() {
        return ArrayUtil.clone((byte[])this.credentialId);
    }

    public @NonNull COSEKey getCOSEKey() {
        return this.coseKey;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AttestedCredentialData that = (AttestedCredentialData)o;
        return Objects.equals(this.aaguid, that.aaguid) && Arrays.equals(this.credentialId, that.credentialId) && Objects.equals(this.coseKey, that.coseKey);
    }

    public int hashCode() {
        int result = Objects.hash(this.aaguid, this.coseKey);
        result = 31 * result + Arrays.hashCode(this.credentialId);
        return result;
    }

    public String toString() {
        return "AttestedCredentialData(aaguid=" + this.aaguid + ", credentialId=" + ArrayUtil.toHexString((byte[])this.credentialId) + ", coseKey=" + this.coseKey + ")";
    }
}

