/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.webauthn4j.data.AttestationConveyancePreference;
import com.webauthn4j.data.AuthenticatorSelectionCriteria;
import com.webauthn4j.data.PublicKeyCredentialDescriptor;
import com.webauthn4j.data.PublicKeyCredentialParameters;
import com.webauthn4j.data.PublicKeyCredentialRpEntity;
import com.webauthn4j.data.PublicKeyCredentialUserEntity;
import com.webauthn4j.data.client.challenge.Challenge;
import com.webauthn4j.data.extension.client.AuthenticationExtensionsClientInputs;
import com.webauthn4j.data.extension.client.RegistrationExtensionClientInput;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.util.CollectionUtil;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class PublicKeyCredentialCreationOptions {
    private final PublicKeyCredentialRpEntity rp;
    private final PublicKeyCredentialUserEntity user;
    private final Challenge challenge;
    private final List<PublicKeyCredentialParameters> pubKeyCredParams;
    private final Long timeout;
    private final List<PublicKeyCredentialDescriptor> excludeCredentials;
    private final AuthenticatorSelectionCriteria authenticatorSelection;
    private final AttestationConveyancePreference attestation;
    private final AuthenticationExtensionsClientInputs<RegistrationExtensionClientInput> extensions;

    @JsonCreator
    public PublicKeyCredentialCreationOptions(@JsonProperty(value="rp") @NonNull PublicKeyCredentialRpEntity rp, @JsonProperty(value="user") @NonNull PublicKeyCredentialUserEntity user, @JsonProperty(value="challenge") @NonNull Challenge challenge, @JsonProperty(value="pubKeyCredParams") @NonNull List<PublicKeyCredentialParameters> pubKeyCredParams, @JsonProperty(value="timeout") @Nullable Long timeout, @JsonProperty(value="excludeCredentials") @Nullable List<PublicKeyCredentialDescriptor> excludeCredentials, @JsonProperty(value="authenticatorSelection") @Nullable AuthenticatorSelectionCriteria authenticatorSelection, @JsonProperty(value="attestation") @Nullable AttestationConveyancePreference attestation, @JsonProperty(value="extensions") @Nullable AuthenticationExtensionsClientInputs<RegistrationExtensionClientInput> extensions) {
        AssertUtil.notNull((Object)rp, (String)"rp must not be null");
        AssertUtil.notNull((Object)user, (String)"user must not be null");
        AssertUtil.notNull((Object)challenge, (String)"challenge must not be null");
        AssertUtil.notNull(pubKeyCredParams, (String)"pubKeyCredParams must not be null");
        this.rp = rp;
        this.user = user;
        this.challenge = challenge;
        this.pubKeyCredParams = CollectionUtil.unmodifiableList(pubKeyCredParams);
        this.timeout = timeout;
        this.excludeCredentials = CollectionUtil.unmodifiableList(excludeCredentials);
        this.authenticatorSelection = authenticatorSelection;
        this.attestation = attestation;
        this.extensions = extensions;
    }

    public PublicKeyCredentialCreationOptions(@NonNull PublicKeyCredentialRpEntity rp, @NonNull PublicKeyCredentialUserEntity user, @NonNull Challenge challenge, @NonNull List<PublicKeyCredentialParameters> pubKeyCredParams) {
        this(rp, user, challenge, pubKeyCredParams, null, Collections.emptyList(), null, null, null);
    }

    public @NonNull PublicKeyCredentialRpEntity getRp() {
        return this.rp;
    }

    public @NonNull PublicKeyCredentialUserEntity getUser() {
        return this.user;
    }

    public @NonNull Challenge getChallenge() {
        return this.challenge;
    }

    public @NonNull List<PublicKeyCredentialParameters> getPubKeyCredParams() {
        return this.pubKeyCredParams;
    }

    public @Nullable Long getTimeout() {
        return this.timeout;
    }

    public @Nullable List<PublicKeyCredentialDescriptor> getExcludeCredentials() {
        return this.excludeCredentials;
    }

    public @Nullable AuthenticatorSelectionCriteria getAuthenticatorSelection() {
        return this.authenticatorSelection;
    }

    public @Nullable AttestationConveyancePreference getAttestation() {
        return this.attestation;
    }

    public @Nullable AuthenticationExtensionsClientInputs<RegistrationExtensionClientInput> getExtensions() {
        return this.extensions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PublicKeyCredentialCreationOptions that = (PublicKeyCredentialCreationOptions)o;
        return Objects.equals(this.rp, that.rp) && Objects.equals(this.user, that.user) && Objects.equals(this.challenge, that.challenge) && Objects.equals(this.pubKeyCredParams, that.pubKeyCredParams) && Objects.equals(this.timeout, that.timeout) && Objects.equals(this.excludeCredentials, that.excludeCredentials) && Objects.equals(this.authenticatorSelection, that.authenticatorSelection) && Objects.equals(this.attestation, that.attestation) && Objects.equals(this.extensions, that.extensions);
    }

    public int hashCode() {
        return Objects.hash(this.rp, this.user, this.challenge, this.pubKeyCredParams, this.timeout, this.excludeCredentials, this.authenticatorSelection, this.attestation, this.extensions);
    }

    public String toString() {
        return "PublicKeyCredentialCreationOptions(rp=" + this.rp + ", user=" + this.user + ", challenge=" + this.challenge + ", pubKeyCredParams=" + this.pubKeyCredParams + ", timeout=" + this.timeout + ", excludeCredentials=" + this.excludeCredentials + ", authenticatorSelection=" + this.authenticatorSelection + ", attestation=" + this.attestation + ", extensions=" + this.extensions + ")";
    }
}

