/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.attestation.statement;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.webauthn4j.data.attestation.statement.AttestationCertificatePath;
import com.webauthn4j.data.attestation.statement.CertificateBaseAttestationStatement;
import com.webauthn4j.data.attestation.statement.Response;
import com.webauthn4j.data.jws.JWS;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.validator.exception.ConstraintViolationException;
import java.security.cert.CertPath;
import java.security.cert.X509Certificate;
import java.util.Objects;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@JsonTypeName(value="android-safetynet")
public class AndroidSafetyNetAttestationStatement
implements CertificateBaseAttestationStatement {
    public static final String FORMAT = "android-safetynet";
    private final String ver;
    private final JWS<Response> response;

    @JsonCreator
    public AndroidSafetyNetAttestationStatement(@JsonProperty(value="ver") @NonNull String ver, @JsonProperty(value="response") @NonNull JWS<Response> response) {
        AssertUtil.notNull((Object)ver, (String)"ver must not be null");
        AssertUtil.notNull(response, (String)"response must not be null");
        this.ver = ver;
        this.response = response;
    }

    @Override
    @JsonIgnore
    public @NonNull String getFormat() {
        return FORMAT;
    }

    @Override
    @JsonIgnore
    public @Nullable AttestationCertificatePath getX5c() {
        JWS<Response> res = this.getResponse();
        CertPath x5c = res.getHeader().getX5c();
        if (x5c == null) {
            return null;
        }
        return new AttestationCertificatePath(x5c.getCertificates().stream().map(X509Certificate.class::cast).collect(Collectors.toList()));
    }

    @Override
    public void validate() {
        CertPath x5c = this.getResponse().getHeader().getX5c();
        if (x5c == null || x5c.getCertificates().isEmpty()) {
            throw new ConstraintViolationException("No attestation certificate is found in android safetynet attestation statement.");
        }
    }

    @JsonGetter(value="ver")
    public @NonNull String getVer() {
        return this.ver;
    }

    @JsonGetter(value="response")
    public @NonNull JWS<Response> getResponse() {
        return this.response;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AndroidSafetyNetAttestationStatement that = (AndroidSafetyNetAttestationStatement)o;
        return Objects.equals(this.ver, that.ver) && Objects.equals(this.response, that.response);
    }

    public int hashCode() {
        return Objects.hash(this.ver, this.response);
    }
}

