/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.converter.jackson.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.webauthn4j.util.exception.UnexpectedCheckedException;
import java.io.IOException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import org.checkerframework.checker.nullness.qual.NonNull;

public class X509CertificateSerializer
extends StdSerializer<X509Certificate> {
    public X509CertificateSerializer() {
        super(X509Certificate.class);
    }

    public void serialize(@NonNull X509Certificate value, @NonNull JsonGenerator gen, @NonNull SerializerProvider provider) throws IOException {
        try {
            gen.writeBinary(value.getEncoded());
        }
        catch (CertificateEncodingException e) {
            throw new UnexpectedCheckedException((Throwable)e);
        }
    }
}

