/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.converter.jackson.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.webauthn4j.data.jws.JWSHeader;
import com.webauthn4j.util.Base64Util;
import com.webauthn4j.util.exception.UnexpectedCheckedException;
import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;

public class JWSHeaderSerializer
extends StdSerializer<JWSHeader> {
    public JWSHeaderSerializer() {
        super(JWSHeader.class);
    }

    public void serialize(JWSHeader value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        try {
            gen.writeStartObject();
            gen.writeObjectField("alg", (Object)value.getAlg());
            gen.writeFieldName("x5c");
            gen.writeStartArray();
            if (value.getX5c() != null) {
                for (Certificate certificate : value.getX5c().getCertificates()) {
                    gen.writeString(Base64Util.encodeToString((byte[])certificate.getEncoded()));
                }
            }
            gen.writeEndArray();
        }
        catch (CertificateEncodingException e) {
            throw new UnexpectedCheckedException((Throwable)e);
        }
    }
}

