/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.anchor;

import com.webauthn4j.anchor.TrustAnchorsProvider;
import com.webauthn4j.anchor.TrustAnchorsResolver;
import com.webauthn4j.data.attestation.authenticator.AAGUID;
import com.webauthn4j.util.AssertUtil;
import java.security.cert.TrustAnchor;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;

public class TrustAnchorsResolverImpl
implements TrustAnchorsResolver {
    private final TrustAnchorsProvider trustAnchorsProvider;

    public TrustAnchorsResolverImpl(@NonNull TrustAnchorsProvider trustAnchorsProvider) {
        AssertUtil.notNull((Object)trustAnchorsProvider, (String)"trustAnchorsProvider must not be null");
        this.trustAnchorsProvider = trustAnchorsProvider;
    }

    @Override
    public @NonNull Set<TrustAnchor> resolve(@NonNull AAGUID aaguid) {
        AssertUtil.notNull((Object)aaguid, (String)"aaguid must not be null");
        Map<AAGUID, Set<TrustAnchor>> trustAnchors = this.trustAnchorsProvider.provide();
        HashSet<TrustAnchor> set = new HashSet<TrustAnchor>();
        set.addAll(trustAnchors.getOrDefault(AAGUID.NULL, Collections.emptySet()));
        set.addAll(trustAnchors.getOrDefault(aaguid, Collections.emptySet()));
        return set;
    }
}

