/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.anchor;

import com.webauthn4j.anchor.CachingTrustAnchorsProviderBase;
import com.webauthn4j.data.attestation.authenticator.AAGUID;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.util.CertificateUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;

public class CertFileTrustAnchorsProvider
extends CachingTrustAnchorsProviderBase {
    private static final String CERTIFICATES_MUST_NOT_BE_NULL = "challenge must not be null";
    private List<Path> certificates;

    public CertFileTrustAnchorsProvider() {
        this.certificates = Collections.emptyList();
    }

    public CertFileTrustAnchorsProvider(@NonNull List<Path> certificates) {
        AssertUtil.notNull(certificates, (String)CERTIFICATES_MUST_NOT_BE_NULL);
        this.certificates = certificates;
    }

    private void checkConfig() {
        AssertUtil.notNull(this.certificates, (String)CERTIFICATES_MUST_NOT_BE_NULL);
    }

    @Override
    protected @NonNull Map<AAGUID, Set<TrustAnchor>> loadTrustAnchors() {
        this.checkConfig();
        Set trustAnchors = this.certificates.stream().map(this::loadTrustAnchor).collect(Collectors.toSet());
        return Collections.singletonMap(AAGUID.NULL, trustAnchors);
    }

    private @NonNull TrustAnchor loadTrustAnchor(@NonNull Path certificate) {
        AssertUtil.notNull((Object)certificate, (String)CERTIFICATES_MUST_NOT_BE_NULL);
        try {
            X509Certificate x509Certificate = CertificateUtil.generateX509Certificate((InputStream)Files.newInputStream(certificate, new OpenOption[0]));
            return new TrustAnchor(x509Certificate, null);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public @NonNull List<Path> getCertificates() {
        return this.certificates;
    }

    public void setCertificates(@NonNull List<Path> certificates) {
        AssertUtil.notNull(certificates, (String)CERTIFICATES_MUST_NOT_BE_NULL);
        this.certificates = certificates;
    }
}

