/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.validator;

import com.webauthn4j.data.client.TokenBinding;
import com.webauthn4j.data.client.TokenBindingStatus;
import com.webauthn4j.util.Base64UrlUtil;
import com.webauthn4j.validator.exception.TokenBindingException;
import java.util.Arrays;
import org.checkerframework.checker.nullness.qual.Nullable;

class TokenBindingValidator {
    TokenBindingValidator() {
    }

    public void validate(@Nullable TokenBinding clientDataTokenBinding, @Nullable byte[] serverTokenBindingId) {
        if (clientDataTokenBinding != null) {
            byte[] clientDataTokenBindingId = clientDataTokenBinding.getId() == null ? null : Base64UrlUtil.decode((String)clientDataTokenBinding.getId());
            TokenBindingStatus tokenBindingStatus = clientDataTokenBinding.getStatus();
            switch (tokenBindingStatus) {
                case NOT_SUPPORTED: 
                case SUPPORTED: {
                    break;
                }
                case PRESENT: {
                    if (Arrays.equals(clientDataTokenBindingId, serverTokenBindingId)) break;
                    throw new TokenBindingException("TokenBinding id does not match");
                }
            }
        }
    }
}

