/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.extension.authenticator;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.webauthn4j.converter.jackson.deserializer.CredentialProtectionPolicyByteDeserializer;
import com.webauthn4j.converter.jackson.serializer.CredentialProtectionPolicyByteSerializer;
import com.webauthn4j.data.extension.CredentialProtectionPolicy;
import com.webauthn4j.data.extension.authenticator.AuthenticationExtensionAuthenticatorInput;
import com.webauthn4j.data.extension.authenticator.CredentialProtectionExtensionAuthenticatorInput;
import com.webauthn4j.data.extension.authenticator.ExtensionAuthenticatorInput;
import com.webauthn4j.data.extension.authenticator.RegistrationExtensionAuthenticatorInput;
import com.webauthn4j.data.extension.authenticator.UserVerificationMethodExtensionAuthenticatorInput;
import com.webauthn4j.util.AssertUtil;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class AuthenticationExtensionsAuthenticatorInputs<T extends ExtensionAuthenticatorInput>
implements Serializable {
    @JsonIgnore
    private final Map<String, Serializable> unknowns = new HashMap<String, Serializable>();
    @JsonProperty
    private Boolean uvm;
    @JsonSerialize(using=CredentialProtectionPolicyByteSerializer.class)
    @JsonDeserialize(using=CredentialProtectionPolicyByteDeserializer.class)
    @JsonProperty
    private CredentialProtectionPolicy credProtect;
    @JsonIgnore
    private Map<Class<? extends T>, T> extensions;

    @JsonAnyGetter
    private Map<String, Serializable> getUnknowns() {
        return Collections.unmodifiableMap(this.unknowns);
    }

    @JsonAnySetter
    private void setUnknowns(@NonNull String name, @Nullable Serializable value) {
        this.unknowns.put(name, value);
    }

    @JsonIgnore
    public @NonNull Set<String> getKeys() {
        HashSet<String> keys = new HashSet<String>();
        if (this.uvm != null) {
            keys.add("uvm");
        }
        if (this.credProtect != null) {
            keys.add("credProtect");
        }
        keys.addAll(this.getUnknownKeys());
        return keys;
    }

    @JsonIgnore
    public @NonNull Set<String> getUnknownKeys() {
        return this.unknowns.keySet();
    }

    @JsonIgnore
    public @Nullable Object getValue(String key) {
        switch (key) {
            case "uvm": {
                return this.uvm;
            }
            case "credProtect": {
                return this.credProtect;
            }
        }
        return this.unknowns.get(key);
    }

    @JsonIgnore
    public @Nullable Boolean getUvm() {
        return this.uvm;
    }

    @JsonIgnore
    public @Nullable CredentialProtectionPolicy getCredProtect() {
        return this.credProtect;
    }

    public <E extends T> @Nullable E getExtension(@NonNull Class<E> tClass) {
        return (E)((ExtensionAuthenticatorInput)this.getExtensions().get(tClass));
    }

    @JsonIgnore
    private @NonNull Map<Class<? extends T>, T> getExtensions() {
        if (this.extensions == null) {
            HashMap<Class, RegistrationExtensionAuthenticatorInput> map = new HashMap<Class, RegistrationExtensionAuthenticatorInput>();
            if (this.uvm != null) {
                map.put(UserVerificationMethodExtensionAuthenticatorInput.class, new UserVerificationMethodExtensionAuthenticatorInput(this.uvm));
            }
            if (this.credProtect != null) {
                map.put(CredentialProtectionExtensionAuthenticatorInput.class, new CredentialProtectionExtensionAuthenticatorInput(this.credProtect));
            }
            this.extensions = Collections.unmodifiableMap(map);
        }
        return this.extensions;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthenticationExtensionsAuthenticatorInputs that = (AuthenticationExtensionsAuthenticatorInputs)o;
        return Objects.equals(this.uvm, that.uvm) && Objects.equals((Object)this.credProtect, (Object)that.credProtect) && Objects.equals(this.unknowns, that.unknowns) && Objects.equals(this.extensions, that.extensions);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.uvm, this.credProtect, this.unknowns, this.extensions});
    }

    public static class BuilderForAuthentication {
        private final Map<String, Serializable> unknowns = new HashMap<String, Serializable>();
        private Boolean uvm;

        public @NonNull AuthenticationExtensionsAuthenticatorInputs<AuthenticationExtensionAuthenticatorInput> build() {
            AuthenticationExtensionsAuthenticatorInputs<AuthenticationExtensionAuthenticatorInput> instance = new AuthenticationExtensionsAuthenticatorInputs<AuthenticationExtensionAuthenticatorInput>();
            ((AuthenticationExtensionsAuthenticatorInputs)instance).uvm = this.uvm;
            ((AuthenticationExtensionsAuthenticatorInputs)instance).unknowns.putAll(this.unknowns);
            return instance;
        }

        public @NonNull BuilderForAuthentication setUvm(@Nullable Boolean uvm) {
            this.uvm = uvm;
            return this;
        }

        public @NonNull BuilderForAuthentication set(@NonNull String key, @Nullable Serializable value) {
            AssertUtil.notNull((Object)key, (String)"key must not be null.");
            AssertUtil.notNull((Object)value, (String)"value must not be null.");
            this.unknowns.put(key, value);
            return this;
        }
    }

    public static class BuilderForRegistration {
        private final Map<String, Serializable> unknowns = new HashMap<String, Serializable>();
        private Boolean uvm;
        private CredentialProtectionPolicy credProtect;

        public @NonNull AuthenticationExtensionsAuthenticatorInputs<RegistrationExtensionAuthenticatorInput> build() {
            AuthenticationExtensionsAuthenticatorInputs<RegistrationExtensionAuthenticatorInput> instance = new AuthenticationExtensionsAuthenticatorInputs<RegistrationExtensionAuthenticatorInput>();
            ((AuthenticationExtensionsAuthenticatorInputs)instance).uvm = this.uvm;
            ((AuthenticationExtensionsAuthenticatorInputs)instance).credProtect = this.credProtect;
            ((AuthenticationExtensionsAuthenticatorInputs)instance).unknowns.putAll(this.unknowns);
            return instance;
        }

        public @NonNull BuilderForRegistration setUvm(@Nullable Boolean uvm) {
            this.uvm = uvm;
            return this;
        }

        public @NonNull BuilderForRegistration setCredProtect(@Nullable CredentialProtectionPolicy credProtect) {
            this.credProtect = credProtect;
            return this;
        }

        public @NonNull BuilderForRegistration set(@NonNull String key, @Nullable Serializable value) {
            AssertUtil.notNull((Object)key, (String)"key must not be null.");
            AssertUtil.notNull((Object)value, (String)"value must not be null.");
            this.unknowns.put(key, value);
            return this;
        }
    }
}

