/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.client;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.webauthn4j.data.client.ClientDataType;
import com.webauthn4j.data.client.Origin;
import com.webauthn4j.data.client.TokenBinding;
import com.webauthn4j.data.client.challenge.Challenge;
import com.webauthn4j.util.AssertUtil;
import java.io.Serializable;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class CollectedClientData
implements Serializable {
    private ClientDataType type;
    private Challenge challenge;
    private Origin origin;
    private TokenBinding tokenBinding;

    @JsonCreator
    public CollectedClientData(@JsonProperty(value="type") @NonNull ClientDataType type, @JsonProperty(value="challenge") @NonNull Challenge challenge, @JsonProperty(value="origin") @NonNull Origin origin, @JsonProperty(value="tokenBinding") @Nullable TokenBinding tokenBinding) {
        AssertUtil.notNull((Object)((Object)type), (String)"type must not be null");
        AssertUtil.notNull((Object)challenge, (String)"challenge must not be null");
        AssertUtil.notNull((Object)origin, (String)"origin must not be null");
        this.type = type;
        this.challenge = challenge;
        this.origin = origin;
        this.tokenBinding = tokenBinding;
    }

    public @NonNull ClientDataType getType() {
        return this.type;
    }

    public @NonNull Challenge getChallenge() {
        return this.challenge;
    }

    public @NonNull Origin getOrigin() {
        return this.origin;
    }

    public @Nullable TokenBinding getTokenBinding() {
        return this.tokenBinding;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CollectedClientData that = (CollectedClientData)o;
        return this.type == that.type && Objects.equals(this.challenge, that.challenge) && Objects.equals(this.origin, that.origin) && Objects.equals(this.tokenBinding, that.tokenBinding);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.challenge, this.origin, this.tokenBinding});
    }
}

