/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data;

import com.webauthn4j.authenticator.CoreAuthenticator;
import com.webauthn4j.server.CoreServerProperty;
import com.webauthn4j.util.AssertUtil;
import java.io.Serializable;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class CoreAuthenticationParameters
implements Serializable {
    private final CoreServerProperty serverProperty;
    private final CoreAuthenticator authenticator;
    private final boolean userVerificationRequired;
    private final boolean userPresenceRequired;

    public CoreAuthenticationParameters(@NonNull CoreServerProperty serverProperty, @NonNull CoreAuthenticator authenticator, boolean userVerificationRequired, boolean userPresenceRequired) {
        AssertUtil.notNull((Object)serverProperty, (String)"serverProperty must not be null");
        AssertUtil.notNull((Object)authenticator, (String)"authenticator must not be null");
        this.serverProperty = serverProperty;
        this.authenticator = authenticator;
        this.userVerificationRequired = userVerificationRequired;
        this.userPresenceRequired = userPresenceRequired;
    }

    public CoreAuthenticationParameters(@NonNull CoreServerProperty serverProperty, @NonNull CoreAuthenticator authenticator, boolean userVerificationRequired) {
        this(serverProperty, authenticator, userVerificationRequired, true);
    }

    public @NonNull CoreServerProperty getServerProperty() {
        return this.serverProperty;
    }

    public @NonNull CoreAuthenticator getAuthenticator() {
        return this.authenticator;
    }

    public boolean isUserVerificationRequired() {
        return this.userVerificationRequired;
    }

    public boolean isUserPresenceRequired() {
        return this.userPresenceRequired;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CoreAuthenticationParameters that = (CoreAuthenticationParameters)o;
        return this.userVerificationRequired == that.userVerificationRequired && this.userPresenceRequired == that.userPresenceRequired && Objects.equals(this.serverProperty, that.serverProperty) && Objects.equals(this.authenticator, that.authenticator);
    }

    public int hashCode() {
        return Objects.hash(this.serverProperty, this.authenticator, this.userVerificationRequired, this.userPresenceRequired);
    }
}

