/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.validator;

import com.webauthn4j.authenticator.CoreAuthenticator;
import com.webauthn4j.data.attestation.authenticator.AuthenticatorData;
import com.webauthn4j.data.extension.authenticator.AuthenticationExtensionAuthenticatorOutput;
import com.webauthn4j.server.CoreServerProperty;
import com.webauthn4j.util.ArrayUtil;
import java.util.Arrays;
import java.util.Objects;

public class CoreAuthenticationObject {
    private final byte[] credentialId;
    private final AuthenticatorData<AuthenticationExtensionAuthenticatorOutput> authenticatorData;
    private final byte[] authenticatorDataBytes;
    private final byte[] clientDataHash;
    private final CoreServerProperty serverProperty;
    private final CoreAuthenticator authenticator;

    public CoreAuthenticationObject(byte[] credentialId, AuthenticatorData<AuthenticationExtensionAuthenticatorOutput> authenticatorData, byte[] authenticatorDataBytes, byte[] clientDataHash, CoreServerProperty serverProperty, CoreAuthenticator authenticator) {
        this.credentialId = ArrayUtil.clone((byte[])credentialId);
        this.authenticatorData = authenticatorData;
        this.authenticatorDataBytes = ArrayUtil.clone((byte[])authenticatorDataBytes);
        this.clientDataHash = ArrayUtil.clone((byte[])clientDataHash);
        this.serverProperty = serverProperty;
        this.authenticator = authenticator;
    }

    public byte[] getCredentialId() {
        return ArrayUtil.clone((byte[])this.credentialId);
    }

    public AuthenticatorData<AuthenticationExtensionAuthenticatorOutput> getAuthenticatorData() {
        return this.authenticatorData;
    }

    public byte[] getAuthenticatorDataBytes() {
        return ArrayUtil.clone((byte[])this.authenticatorDataBytes);
    }

    public byte[] getClientDataHash() {
        return ArrayUtil.clone((byte[])this.clientDataHash);
    }

    public CoreServerProperty getServerProperty() {
        return this.serverProperty;
    }

    public CoreAuthenticator getAuthenticator() {
        return this.authenticator;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CoreAuthenticationObject that = (CoreAuthenticationObject)o;
        return Arrays.equals(this.credentialId, that.credentialId) && Objects.equals(this.authenticatorData, that.authenticatorData) && Arrays.equals(this.authenticatorDataBytes, that.authenticatorDataBytes) && Arrays.equals(this.clientDataHash, that.clientDataHash) && Objects.equals(this.serverProperty, that.serverProperty) && Objects.equals(this.authenticator, that.authenticator);
    }

    public int hashCode() {
        int result = Objects.hash(this.authenticatorData, this.serverProperty, this.authenticator);
        result = 31 * result + Arrays.hashCode(this.credentialId);
        result = 31 * result + Arrays.hashCode(this.authenticatorDataBytes);
        result = 31 * result + Arrays.hashCode(this.clientDataHash);
        return result;
    }
}

