/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.validator;

import com.webauthn4j.data.CoreAuthenticationData;
import com.webauthn4j.data.SignatureAlgorithm;
import com.webauthn4j.data.attestation.authenticator.COSEKey;
import com.webauthn4j.validator.exception.BadSignatureException;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssertionSignatureValidator {
    private final Logger logger = LoggerFactory.getLogger(AssertionSignatureValidator.class);

    public void validate(CoreAuthenticationData authenticationData, COSEKey coseKey) {
        byte[] signedData = this.getSignedData(authenticationData);
        byte[] signature = authenticationData.getSignature();
        if (!this.verifySignature(coseKey, signature, signedData)) {
            throw new BadSignatureException("Assertion signature is not valid.");
        }
    }

    protected byte[] getSignedData(CoreAuthenticationData authenticationData) {
        byte[] rawAuthenticatorData = authenticationData.getAuthenticatorDataBytes();
        byte[] clientDataHash = authenticationData.getClientDataHash();
        return ByteBuffer.allocate(rawAuthenticatorData.length + clientDataHash.length).put(rawAuthenticatorData).put(clientDataHash).array();
    }

    private boolean verifySignature(COSEKey coseKey, byte[] signature, byte[] data) {
        try {
            PublicKey publicKey = coseKey.getPublicKey();
            SignatureAlgorithm signatureAlgorithm = coseKey.getAlgorithm().toSignatureAlgorithm();
            String jcaName = signatureAlgorithm.getJcaName();
            Signature verifier = Signature.getInstance(jcaName);
            verifier.initVerify(publicKey);
            verifier.update(data);
            return verifier.verify(signature);
        }
        catch (IllegalArgumentException e) {
            this.logger.debug("COSE key alg must be signature algorithm.", (Throwable)e);
            return false;
        }
        catch (RuntimeException | InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            this.logger.debug("Unexpected exception is thrown during signature verification.", (Throwable)e);
            return false;
        }
    }
}

