/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.server;

import com.webauthn4j.data.client.Origin;
import com.webauthn4j.data.client.challenge.Challenge;
import com.webauthn4j.server.CoreServerProperty;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class ServerProperty
extends CoreServerProperty {
    private final Set<Origin> origins;
    private final byte[] tokenBindingId;

    public ServerProperty(Origin origin, String rpId, Challenge challenge, byte[] tokenBindingId) {
        this(origin != null ? Collections.singleton(origin) : Collections.emptySet(), rpId, challenge, tokenBindingId);
    }

    public ServerProperty(Collection<Origin> origins, String rpId, Challenge challenge, byte[] tokenBindingId) {
        super(rpId, challenge);
        this.origins = origins != null && !origins.isEmpty() ? Collections.unmodifiableSet(new HashSet<Origin>(origins)) : Collections.emptySet();
        this.tokenBindingId = tokenBindingId;
    }

    @Deprecated
    public Origin getOrigin() {
        int originsSize = this.origins.size();
        switch (originsSize) {
            case 0: {
                return null;
            }
            case 1: {
                return this.origins.iterator().next();
            }
        }
        throw new IllegalStateException("There are multiple Origins associated with this ServerProperty");
    }

    public Set<Origin> getOrigins() {
        return this.origins;
    }

    public byte[] getTokenBindingId() {
        return this.tokenBindingId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServerProperty that = (ServerProperty)o;
        return Objects.equals(this.origins, that.origins) && Arrays.equals(this.tokenBindingId, that.tokenBindingId);
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(super.hashCode(), this.origins);
        result = 31 * result + Arrays.hashCode(this.tokenBindingId);
        return result;
    }
}

