/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.attestation.statement;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.webauthn4j.data.attestation.statement.AttestationCertificatePath;
import com.webauthn4j.data.attestation.statement.COSEAlgorithmIdentifier;
import com.webauthn4j.data.attestation.statement.CertificateBaseAttestationStatement;
import com.webauthn4j.util.ArrayUtil;
import com.webauthn4j.validator.exception.ConstraintViolationException;
import java.util.Arrays;
import java.util.Objects;

@JsonIgnoreProperties(value={"format"})
@JsonTypeName(value="packed")
public class PackedAttestationStatement
implements CertificateBaseAttestationStatement {
    public static final String FORMAT = "packed";
    @JsonProperty
    private final COSEAlgorithmIdentifier alg;
    @JsonProperty
    private final byte[] sig;
    @JsonProperty
    private final AttestationCertificatePath x5c;

    public PackedAttestationStatement(@JsonProperty(value="alg") COSEAlgorithmIdentifier alg, @JsonProperty(value="sig") byte[] sig, @JsonProperty(value="x5c") AttestationCertificatePath x5c) {
        this.alg = alg;
        this.sig = sig;
        this.x5c = x5c;
    }

    public COSEAlgorithmIdentifier getAlg() {
        return this.alg;
    }

    public byte[] getSig() {
        return ArrayUtil.clone((byte[])this.sig);
    }

    @Override
    public AttestationCertificatePath getX5c() {
        return this.x5c;
    }

    @Override
    @JsonIgnore
    public String getFormat() {
        return FORMAT;
    }

    @Override
    public void validate() {
        if (this.alg == null) {
            throw new ConstraintViolationException("alg must not be null");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PackedAttestationStatement that = (PackedAttestationStatement)o;
        return Objects.equals(this.alg, that.alg) && Arrays.equals(this.sig, that.sig) && Objects.equals(this.x5c, that.x5c);
    }

    public int hashCode() {
        int result = Objects.hash(this.alg, this.x5c);
        result = 31 * result + Arrays.hashCode(this.sig);
        return result;
    }
}

