/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.webauthn4j.data.MessageDigestAlgorithm;
import java.util.Objects;

public class SignatureAlgorithm {
    public static final SignatureAlgorithm ES256 = new SignatureAlgorithm("SHA256withECDSA", MessageDigestAlgorithm.SHA256);
    public static final SignatureAlgorithm ES384 = new SignatureAlgorithm("SHA384withECDSA", MessageDigestAlgorithm.SHA384);
    public static final SignatureAlgorithm ES512 = new SignatureAlgorithm("SHA512withECDSA", MessageDigestAlgorithm.SHA512);
    public static final SignatureAlgorithm RS1 = new SignatureAlgorithm("SHA1withRSA", MessageDigestAlgorithm.SHA1);
    public static final SignatureAlgorithm RS256 = new SignatureAlgorithm("SHA256withRSA", MessageDigestAlgorithm.SHA256);
    public static final SignatureAlgorithm RS384 = new SignatureAlgorithm("SHA384withRSA", MessageDigestAlgorithm.SHA384);
    public static final SignatureAlgorithm RS512 = new SignatureAlgorithm("SHA512withRSA", MessageDigestAlgorithm.SHA512);
    private final String jcaName;
    private final MessageDigestAlgorithm messageDigestAlgorithm;

    private SignatureAlgorithm(String jcaName, MessageDigestAlgorithm messageDigestAlgorithm) {
        this.jcaName = jcaName;
        this.messageDigestAlgorithm = messageDigestAlgorithm;
    }

    @JsonCreator
    public static SignatureAlgorithm create(String jcaName) {
        switch (jcaName) {
            case "SHA256withECDSA": {
                return ES256;
            }
            case "SHA384withECDSA": {
                return ES384;
            }
            case "SHA512withECDSA": {
                return ES512;
            }
            case "SHA1withRSA": {
                return RS1;
            }
            case "SHA256withRSA": {
                return RS256;
            }
            case "SHA384withRSA": {
                return RS384;
            }
            case "SHA512withRSA": {
                return RS512;
            }
        }
        throw new IllegalArgumentException(String.format("jcaName %s is not supported.", jcaName));
    }

    public static SignatureAlgorithm create(String jcaName, String messageDigestJcaName) {
        return new SignatureAlgorithm(jcaName, MessageDigestAlgorithm.create(messageDigestJcaName));
    }

    @JsonValue
    public String getJcaName() {
        return this.jcaName;
    }

    public MessageDigestAlgorithm getMessageDigestAlgorithm() {
        return this.messageDigestAlgorithm;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SignatureAlgorithm that = (SignatureAlgorithm)o;
        return Objects.equals(this.jcaName, that.jcaName) && Objects.equals(this.messageDigestAlgorithm, that.messageDigestAlgorithm);
    }

    public int hashCode() {
        return Objects.hash(this.jcaName, this.messageDigestAlgorithm);
    }
}

