/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.webauthn4j.util.MessageDigestUtil;
import java.security.MessageDigest;
import java.util.Objects;

public class MessageDigestAlgorithm {
    public static final MessageDigestAlgorithm SHA1 = new MessageDigestAlgorithm("SHA-1");
    public static final MessageDigestAlgorithm SHA256 = new MessageDigestAlgorithm("SHA-256");
    public static final MessageDigestAlgorithm SHA384 = new MessageDigestAlgorithm("SHA-384");
    public static final MessageDigestAlgorithm SHA512 = new MessageDigestAlgorithm("SHA-512");
    private final String jcaName;

    private MessageDigestAlgorithm(String jcaName) {
        this.jcaName = jcaName;
    }

    @JsonCreator
    public static MessageDigestAlgorithm create(String jcaName) {
        return new MessageDigestAlgorithm(jcaName);
    }

    @JsonValue
    public String getJcaName() {
        return this.jcaName;
    }

    public MessageDigest createMessageDigestObject() {
        return MessageDigestUtil.createMessageDigest((String)this.jcaName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessageDigestAlgorithm that = (MessageDigestAlgorithm)o;
        return Objects.equals(this.jcaName, that.jcaName);
    }

    public int hashCode() {
        return Objects.hash(this.jcaName);
    }
}

