/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data;

import com.webauthn4j.data.attestation.AttestationObject;
import com.webauthn4j.util.ArrayUtil;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;

public class CoreRegistrationData
implements Serializable {
    private final AttestationObject attestationObject;
    private final byte[] attestationObjectBytes;
    private final byte[] clientDataHash;

    public CoreRegistrationData(AttestationObject attestationObject, byte[] attestationObjectBytes, byte[] clientDataHash) {
        this.attestationObject = attestationObject;
        this.attestationObjectBytes = ArrayUtil.clone((byte[])attestationObjectBytes);
        this.clientDataHash = ArrayUtil.clone((byte[])clientDataHash);
    }

    public AttestationObject getAttestationObject() {
        return this.attestationObject;
    }

    public byte[] getAttestationObjectBytes() {
        return ArrayUtil.clone((byte[])this.attestationObjectBytes);
    }

    public byte[] getClientDataHash() {
        return ArrayUtil.clone((byte[])this.clientDataHash);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CoreRegistrationData that = (CoreRegistrationData)o;
        return Objects.equals(this.attestationObject, that.attestationObject) && Arrays.equals(this.attestationObjectBytes, that.attestationObjectBytes) && Arrays.equals(this.clientDataHash, that.clientDataHash);
    }

    public int hashCode() {
        int result = Objects.hash(this.attestationObject);
        result = 31 * result + Arrays.hashCode(this.attestationObjectBytes);
        result = 31 * result + Arrays.hashCode(this.clientDataHash);
        return result;
    }
}

